/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.logging;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SourcePosition;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class GlobalPosition
implements Closeable {
    private static final ThreadLocal<GlobalPosition> GLOBAL_POSITION = new ThreadLocal();
    private final GlobalPosition prev = GLOBAL_POSITION.get();
    private final SourcePosition pos;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public GlobalPosition(Doc doc) {
        this(doc != null ? doc.position() : null);
    }

    public GlobalPosition(SourcePosition pos) {
        this.pos = pos;
        if (pos != null) {
            this.setPos(this);
        }
    }

    public static SourcePosition current() {
        GlobalPosition current = GLOBAL_POSITION.get();
        return current != null ? current.pos : null;
    }

    private void setPos(GlobalPosition pos) {
        if (pos == null) {
            GLOBAL_POSITION.remove();
        } else {
            GLOBAL_POSITION.set(pos);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.setPos(this.prev);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{closed: " + this.closed + ", pos: " + this.pos + '}';
    }
}

