/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.logging;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.SourcePosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;

public class LogSupport
implements DocErrorReporter {
    private static final Logger LOGGER = Logger.getLogger(LogSupport.class.getName());
    private static volatile DocErrorReporter reporter;

    public static void setReporter(DocErrorReporter reporter) {
        LogSupport.reporter = reporter;
    }

    public static void setLevel(Object level) {
        switch (Objects.toString(level, "INFO").toUpperCase(Locale.ENGLISH).trim()) {
            case "ALL": 
            case "TRACE": 
            case "FINEST": {
                LOGGER.setLevel(Level.FINEST);
                break;
            }
            case "FINER": {
                LOGGER.setLevel(Level.FINER);
                break;
            }
            case "DEBUG": 
            case "FINE": {
                LOGGER.setLevel(Level.FINE);
                break;
            }
            case "CONFIG": {
                LOGGER.setLevel(Level.CONFIG);
                break;
            }
            case "INFO": {
                LOGGER.setLevel(Level.INFO);
                break;
            }
            case "WARN": 
            case "WARNING": {
                LOGGER.setLevel(Level.WARNING);
                break;
            }
            case "ERROR": 
            case "FATAL": 
            case "SEVERE": {
                LOGGER.setLevel(Level.SEVERE);
                break;
            }
            case "OFF": {
                LOGGER.setLevel(Level.OFF);
                break;
            }
            default: {
                throw new IllegalArgumentException(LogSupport.format("Unsupported log level \"{0}\"!", level));
            }
        }
    }

    private static String format(String msg, Object ... args) {
        return MessageFormat.format(msg, args);
    }

    public static boolean isTraceEnabled() {
        return LOGGER.isLoggable(Level.FINEST);
    }

    public static void trace(String msg, Object ... args) {
        if (LogSupport.isTraceEnabled()) {
            if (reporter == null) {
                LOGGER.log(Level.FINEST, LogSupport.format(msg, args), LogSupport.findException(args));
            } else {
                reporter.printNotice(GlobalPosition.current(), LogSupport.format(msg, args));
            }
        }
    }

    public static void debug(String msg, Object ... args) {
        if (LOGGER.isLoggable(Level.FINE)) {
            if (reporter == null) {
                LOGGER.log(Level.FINE, LogSupport.format(msg, args), LogSupport.findException(args));
            } else {
                reporter.printNotice(GlobalPosition.current(), LogSupport.format(msg, args));
            }
        }
    }

    public static void info(String msg, Object ... args) {
        if (LOGGER.isLoggable(Level.INFO)) {
            if (reporter == null) {
                LOGGER.log(Level.INFO, LogSupport.format(msg, args), LogSupport.findException(args));
            } else {
                reporter.printNotice(GlobalPosition.current(), LogSupport.format(msg, args));
            }
        }
    }

    public static void warn(String msg, Object ... args) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            if (reporter == null) {
                LOGGER.log(Level.WARNING, LogSupport.format(msg, args), LogSupport.findException(args));
            } else {
                reporter.printWarning(GlobalPosition.current(), LogSupport.format(msg, args));
            }
        }
    }

    public static void error(String msg, Object ... args) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            if (reporter == null) {
                LOGGER.log(Level.SEVERE, LogSupport.format(msg, args), LogSupport.findException(args));
            } else {
                reporter.printError(GlobalPosition.current(), LogSupport.format(msg, args));
            }
        }
    }

    public void printNotice(String msg) {
        LogSupport.info(msg, new Object[0]);
    }

    public void printWarning(String msg) {
        LogSupport.warn(msg, new Object[0]);
    }

    public void printError(String msg) {
        LogSupport.error(msg, new Object[0]);
    }

    public void printNotice(SourcePosition pos, String msg) {
        try (GlobalPosition gp = new GlobalPosition(pos);){
            LogSupport.info(msg, new Object[0]);
        }
    }

    public void printWarning(SourcePosition pos, String msg) {
        try (GlobalPosition gp = new GlobalPosition(pos);){
            LogSupport.warn(msg, new Object[0]);
        }
    }

    public void printError(SourcePosition pos, String msg) {
        try (GlobalPosition gp = new GlobalPosition(pos);){
            LogSupport.error(msg, new Object[0]);
        }
    }

    private static Throwable findException(Object ... args) {
        for (int i = args.length - 1; i >= 0; --i) {
            if (!(args[i] instanceof Throwable)) continue;
            return (Throwable)args[i];
        }
        return null;
    }

    public static String concatLowercaseParts(String ... parts) {
        StringBuilder result = new StringBuilder();
        if (parts != null) {
            for (String part : parts) {
                String string = part = part != null ? part.trim() : "";
                if (part.length() <= 0) continue;
                if (result.length() == 0) {
                    result.append(part);
                    continue;
                }
                result.append(' ').append(Character.toLowerCase(part.charAt(0))).append(part.substring(1));
            }
        }
        return result.toString();
    }
}

