/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public class Concatenation<T>
implements Iterable<T> {
    private final Iterable<T>[] iterables;

    private Concatenation(Iterable<? extends T> ... iterables) {
        this.iterables = iterables;
    }

    public static <T> Concatenation<T> of(Iterable<? extends T> ... iterables) {
        return new Concatenation<T>(iterables);
    }

    public static <U extends T, T> Concatenation<T> append(Iterable<? extends T> iterable, U element) {
        return Concatenation.of(iterable, Collections.singleton(element));
    }

    public static <U extends T, T> Concatenation<T> prepend(U headElement, Iterable<? extends T> tail) {
        return Concatenation.of(Collections.singleton(headElement), tail);
    }

    @Override
    public Iterator<T> iterator() {
        return new ConcIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.asList(this.iterables);
    }

    private class ConcIterator
    implements Iterator<T> {
        int cursor = 0;
        Iterator<T> current;

        private ConcIterator() {
        }

        private Iterator<T> current() {
            if (this.current == null) {
                this.current = Objects.requireNonNull(Concatenation.this.iterables[this.cursor].iterator(), "Current iterator is <null>.");
            }
            while (!this.current.hasNext() && this.cursor < Concatenation.this.iterables.length - 1) {
                this.current = Objects.requireNonNull(Concatenation.this.iterables[++this.cursor].iterator(), "Next iterator is <null>.");
            }
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current().hasNext();
        }

        @Override
        public T next() {
            return this.current().next();
        }

        @Override
        public void remove() {
            this.current().remove();
        }
    }
}

