/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.model;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.rendering.Renderer;

public class Model {
    private static final Set<String> OPTIONAL_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("java.util.Optional", "com.google.common.base.Optional")));

    public static boolean isDeprecated(ProgramElementDoc element) {
        if (element == null) {
            return false;
        }
        if (element.tags("deprecated").length > 0) {
            return true;
        }
        for (AnnotationDesc annotation : element.annotations()) {
            if (!Deprecated.class.getName().equals(annotation.annotationType().qualifiedName())) continue;
            return true;
        }
        return Model.isDeprecated((ProgramElementDoc)element.containingClass()) || element instanceof ClassDoc && Model.isDeprecated((ProgramElementDoc)((ClassDoc)element).superclass());
    }

    public static boolean isInSameOrSubPackage(String packageName, Type type) {
        if (packageName != null && type != null) {
            try {
                String testedPackageNm = type.asClassDoc().containingPackage().name();
                return packageName.equals(testedPackageNm) || testedPackageNm.startsWith(packageName + ".");
            }
            catch (RuntimeException rte) {
                LogSupport.warn("Cannot determine whether type \"{0}\" is within the package \"{1}\".", type, packageName, rte);
            }
        }
        return false;
    }

    public static <R extends Renderer> R find(Iterable<? extends R> haystack, R needle) {
        if (haystack != null && needle != null) {
            for (Renderer straw : haystack) {
                if (!needle.equals(straw)) continue;
                return (R)straw;
            }
        }
        return null;
    }

    public static Type optionalType(Type type) {
        List<Type> chain = Model.superclassChainTo(type, new ArrayList<Type>(), OPTIONAL_TYPES);
        if (chain != null) {
            for (int i = chain.size() - 1; i >= 0; --i) {
                Type[] typeArgs;
                ParameterizedType genericTp = chain.get(i).asParameterizedType();
                Type[] typeArray = typeArgs = genericTp != null ? genericTp.typeArguments() : null;
                if (typeArgs == null || typeArgs.length != 1) continue;
                return typeArgs[0];
            }
        }
        return null;
    }

    public static Type iterableType(Type type) {
        String dimension;
        String string = dimension = type != null ? type.dimension() : null;
        Type iterableType = dimension != null && dimension.startsWith("[") ? type : (Model.isSubtypeOf(Iterable.class, type) ? Model.firstGenericTypeArgumentOf(type) : null);
        LogSupport.trace(iterableType == null ? "Type does not seem to be iterable: {0}." : "Generic type is {1} for iterable {0}.", type, iterableType);
        return iterableType;
    }

    public static boolean isSubtypeOf(Class<?> javaClass, Type type) {
        boolean isSubtype = false;
        if (javaClass != null && type != null) {
            Type supertype;
            Class<?> typeClass;
            isSubtype = javaClass.getName().equals(type.typeName()) ? true : ((typeClass = Model.tryLoadClass(type)) != null && javaClass.isAssignableFrom(typeClass) ? true : (supertype = Model.supertypeOf(type)) != null && Model.isSubtypeOf(javaClass, supertype));
        }
        LogSupport.trace("{0} {1} a subtype of {2}.", type, isSubtype ? "is" : "is not", javaClass);
        return isSubtype;
    }

    private static Type firstGenericTypeArgumentOf(Type type) {
        Type[] typeArgs;
        ParameterizedType parameterized;
        if (type == null) {
            return null;
        }
        Type genericType = Model.firstGenericTypeArgumentOf(Model.supertypeOf(type));
        if (genericType == null && (parameterized = type.asParameterizedType()) != null && (typeArgs = parameterized.typeArguments()) != null && typeArgs.length > 0) {
            genericType = typeArgs[0];
        }
        LogSupport.trace("First generic type is {1} for: {0}.", type, genericType);
        return genericType;
    }

    private static Class<?> tryLoadClass(Type type) {
        try {
            return Class.forName(type.qualifiedTypeName());
        }
        catch (ClassNotFoundException | LinkageError | RuntimeException e) {
            LogSupport.trace("Not a class or unavailable on the classpath: {0}", type);
            return null;
        }
    }

    public static Type supertypeOf(Type type) {
        ClassDoc classDoc;
        Type supertype = null;
        if (type != null && (classDoc = type.asClassDoc()) != null && (supertype = classDoc.superclassType()) == null) {
            Class<?> superclass;
            Class<?> clazz = Model.tryLoadClass(type);
            Class<?> clazz2 = superclass = clazz != null ? clazz.getSuperclass() : null;
            if (superclass != null) {
                try {
                    return classDoc.findClass(superclass.getName());
                }
                catch (RuntimeException e) {
                    LogSupport.trace("Error looking for javadoc of {0}: {1}", superclass, e.toString());
                }
            }
        }
        return supertype;
    }

    private static List<Type> superclassChainTo(Type type, List<Type> chain, Set<String> requestedTypes) {
        if (type == null || chain == null || requestedTypes == null) {
            return null;
        }
        chain.add(type);
        return requestedTypes.contains(type.qualifiedTypeName()) ? chain : Model.superclassChainTo(Model.supertypeOf(type), chain, requestedTypes);
    }
}

