/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.model.Concatenation;

public class Reference {
    public final Side from;
    public final Side to;
    public final String type;
    public final Collection<String> notes;

    public Reference(Side from, String type, Side to, String ... notes) {
        this(from, type, to, notes != null && notes.length > 0 ? Arrays.asList(notes) : null);
    }

    private Reference(Side from, String type, Side to, Iterable<String> notes) {
        this.from = Objects.requireNonNull(from, "Reference \"from\" side is <null>.");
        this.type = Objects.requireNonNull(type, "Reference type is <null>.").trim();
        if (this.type.isEmpty()) {
            throw new IllegalArgumentException("Reference type is empty.");
        }
        this.to = Objects.requireNonNull(to, "Reference \"to\" side is <null>.");
        if (notes == null) {
            this.notes = Collections.emptySet();
        } else {
            LinkedHashSet<String> notesAcc = new LinkedHashSet<String>();
            for (String note : notes) {
                String trimmed = note != null ? note.trim() : "";
                if (trimmed.isEmpty()) continue;
                notesAcc.add(trimmed);
            }
            this.notes = notesAcc.isEmpty() ? Collections.emptySet() : (notesAcc.size() == 1 ? Collections.singleton(notesAcc.iterator().next()) : Collections.unmodifiableSet(notesAcc));
        }
    }

    public boolean isSelfReference() {
        return this.from.qualifiedName.equals(this.to.qualifiedName);
    }

    public Reference addNote(String note) {
        String trimmed = note != null ? note.trim() : "";
        return trimmed.isEmpty() || this.notes.contains(trimmed) ? this : new Reference(this.from, this.type, this.to, Concatenation.append(this.notes, trimmed));
    }

    private Reference inverse() {
        return new Reference(this.to, this.reverseType(), this.from, this.notes);
    }

    public Reference canonical() {
        return this.type.startsWith("<--") || this.type.startsWith("<..") || this.type.endsWith("--|>") || this.type.endsWith("..|>") || this.type.endsWith("--*") || this.type.endsWith("--o") ? this.inverse() : this;
    }

    public int hashCode() {
        Reference ref = this.canonical();
        return Objects.hash(ref.from, ref.type, ref.to);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference t_c = this.canonical();
        Reference o_c = ((Reference)other).canonical();
        return t_c.from.equals(o_c.from) && t_c.type.equals(o_c.type) && t_c.to.equals(o_c.to);
    }

    public String toString() {
        String toCardinality = this.to.cardinality.isEmpty() ? "" : this.to.cardinality + " ";
        return this.from + " " + this.type + " " + toCardinality + this.to.qualifiedName;
    }

    private String reverseType() {
        char[] chars = this.type.toCharArray();
        char swap = chars[0];
        int i = 0;
        int j = chars.length - 1;
        while (i < j) {
            chars[i] = Reference.reverseChar(chars[j]);
            chars[j--] = Reference.reverseChar(swap);
            swap = chars[i++];
        }
        return String.valueOf(chars);
    }

    private static char reverseChar(char ch) {
        return (char)(ch == '<' ? 62 : (ch == '>' ? 60 : (int)ch));
    }

    public static final class Side {
        public final String qualifiedName;
        public final String cardinality;

        public static Side from(String fromQualifiedName) {
            return Side.from(fromQualifiedName, null);
        }

        public static Side from(String fromQualifiedName, String fromCardinality) {
            return new Side(fromQualifiedName, fromCardinality);
        }

        public static Side to(String toQualifiedName) {
            return Side.to(toQualifiedName, null);
        }

        public static Side to(String toQualifiedName, String toCardinality) {
            return new Side(toQualifiedName, toCardinality);
        }

        protected Side(String qualifiedName, String cardinality) {
            this.qualifiedName = Objects.requireNonNull(qualifiedName, "Name of referred object is <null>.").trim();
            if (this.qualifiedName.isEmpty()) {
                throw new IllegalArgumentException("Name of referred object is empty.");
            }
            this.cardinality = cardinality != null ? cardinality.trim() : "";
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName, this.cardinality);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Side && this.qualifiedName.equals(((Side)other).qualifiedName) && this.cardinality.equals(((Side)other).cardinality);
        }

        public String toString() {
            return this.cardinality.isEmpty() ? this.qualifiedName : this.qualifiedName + ' ' + this.cardinality;
        }
    }
}

