/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.util.Collection;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Model;
import nl.talsmasoftware.umldoclet.model.Reference;
import nl.talsmasoftware.umldoclet.rendering.ClassReferenceRenderer;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;
import nl.talsmasoftware.umldoclet.rendering.FieldRenderer;
import nl.talsmasoftware.umldoclet.rendering.MethodRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;

public class ClassPropertyRenderer
extends ClassReferenceRenderer {
    protected ClassPropertyRenderer(ClassRenderer fromClass, ClassDoc toClass, String cardinality) {
        super(fromClass, new Reference(Reference.Side.from(fromClass.classDoc.qualifiedName()), "-->", Reference.Side.to(toClass.qualifiedName(), cardinality), new String[0]));
    }

    static void addDiagramDependenciesTo(Collection<ClassReferenceRenderer> references, ClassRenderer theClass, Collection<ClassDoc> diagramClasses) {
        if (theClass != null) {
            for (Renderer child : theClass.children) {
                ClassPropertyRenderer dep;
                ClassDoc toClass;
                String cardinality;
                MethodRenderer method;
                String propertyname;
                if (child instanceof FieldRenderer) {
                    ClassDoc toClass2;
                    String cardinality2;
                    FieldRenderer field = (FieldRenderer)child;
                    if (!field.includeField() || field.fieldDoc.isStatic()) continue;
                    Type fieldType = Model.optionalType(field.fieldDoc.type());
                    String string = cardinality2 = fieldType != null ? "0..1" : null;
                    if (fieldType == null) {
                        fieldType = Model.iterableType(field.fieldDoc.type());
                        String string2 = cardinality2 = fieldType != null ? "*" : null;
                    }
                    if (fieldType == null) {
                        fieldType = field.fieldDoc.type();
                    }
                    if ((toClass2 = ClassPropertyRenderer.findTypeInDiagram(fieldType, diagramClasses)) == null) continue;
                    ClassPropertyRenderer dep2 = new ClassPropertyRenderer(theClass, toClass2, cardinality2);
                    if (!ClassPropertyRenderer.addDependency(field.fieldDoc.name(), references, dep2)) continue;
                    field.disabled = true;
                    continue;
                }
                if (!(child instanceof MethodRenderer) || (propertyname = (method = (MethodRenderer)child).propertyName()) == null || !(method.methodDoc instanceof MethodDoc)) continue;
                Type type = method.propertyType();
                Type propertyType = Model.optionalType(type);
                String string = cardinality = propertyType != null ? "0..1" : null;
                if (propertyType == null) {
                    propertyType = Model.iterableType(type);
                    String string3 = cardinality = propertyType != null ? "*" : null;
                }
                if (propertyType == null) {
                    propertyType = type;
                }
                if ((toClass = ClassPropertyRenderer.findTypeInDiagram(propertyType, diagramClasses)) == null || !ClassPropertyRenderer.addDependency(propertyname, references, dep = new ClassPropertyRenderer(theClass, toClass, cardinality))) continue;
                method.disabled = true;
            }
        }
    }

    private static ClassDoc findTypeInDiagram(Type type, Collection<ClassDoc> diagramClasses) {
        if (type != null && diagramClasses != null) {
            String qualifiedTypeName = type.qualifiedTypeName();
            for (ClassDoc renderedClass : diagramClasses) {
                if (!qualifiedTypeName.equals(renderedClass.qualifiedTypeName())) continue;
                return renderedClass;
            }
        }
        return null;
    }

    private static boolean addDependency(String name, Collection<ClassReferenceRenderer> refs, ClassPropertyRenderer dep) {
        if (dep.isSelfReference() && dep.classDoc.isEnum()) {
            LogSupport.debug("Not adding self-referencing Enum dependency {0}...", dep);
            return false;
        }
        refs.add(dep);
        ((ClassReferenceRenderer)Model.find(refs, dep)).addNote(name);
        return true;
    }
}

