/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Reference;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;
import nl.talsmasoftware.umldoclet.rendering.LegacyTag;
import nl.talsmasoftware.umldoclet.rendering.MethodRenderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class ClassReferenceRenderer
extends ClassRenderer {
    protected final ClassRenderer parent;
    protected Reference reference;

    private ClassReferenceRenderer(ClassRenderer parent, ClassDoc documentedClass, String umlreference) {
        this(parent, Objects.requireNonNull(documentedClass, "Referred class was <null>.").qualifiedName(), umlreference);
    }

    protected ClassReferenceRenderer(ClassRenderer parent, String referenceFromFqn, String umlreference) {
        this(parent, new Reference(Reference.Side.from(referenceFromFqn), umlreference, Reference.Side.to(Objects.requireNonNull(parent, (String)"Parent was <null>.").classDoc.qualifiedName()), new String[0]));
    }

    protected ClassReferenceRenderer(ClassRenderer parent, Reference reference) {
        super(parent, ClassReferenceRenderer.referredClassDoc(parent, reference));
        this.children.clear();
        this.parent = parent;
        this.reference = Objects.requireNonNull(reference, "Reference is <null>.");
        if (!reference.isSelfReference() && this.diagram.config.includeAbstractSuperclassMethods() && !this.classDoc.equals(parent.classDoc)) {
            for (MethodDoc methodDoc : this.classDoc.methods(false)) {
                if (!methodDoc.isAbstract()) continue;
                this.children.add(new MethodRenderer(this.diagram, (ExecutableMemberDoc)methodDoc));
            }
        }
    }

    private static ClassDoc referredClassDoc(ClassRenderer source, Reference reference) {
        if (source == null) {
            return null;
        }
        if (reference != null) {
            for (Reference.Side side : new Reference.Side[]{reference.to, reference.from}) {
                ClassDoc referredClassDoc;
                if (side.qualifiedName.equals(source.classDoc.qualifiedName()) || (referredClassDoc = source.classDoc.findClass(side.qualifiedName)) == null) continue;
                return referredClassDoc;
            }
        }
        return source.classDoc;
    }

    static Collection<ClassReferenceRenderer> referencesFor(ClassRenderer parent) {
        try (GlobalPosition pos = new GlobalPosition((Doc)parent.classDoc);){
            String superclassName;
            Objects.requireNonNull(parent, "Included class is required in order to find its references.");
            String referentName = parent.classDoc.qualifiedName();
            LogSupport.trace("Adding references for included class {0}...", referentName);
            LinkedHashSet<ClassReferenceRenderer> references = new LinkedHashSet<ClassReferenceRenderer>();
            Collection<String> excludedReferences = parent.diagram.config.excludedReferences();
            ClassDoc superclass = parent.classDoc.superclass();
            String string = superclassName = superclass == null ? null : superclass.qualifiedName();
            if (superclassName == null) {
                LogSupport.debug("Encountered <null> as superclass of \"{0}\".", referentName);
            } else if (excludedReferences.contains(superclassName)) {
                LogSupport.trace("Excluding superclass \"{0}\" of \"{1}\"...", superclassName, referentName);
            } else if (references.add(new ClassReferenceRenderer(parent, superclass, "<|--"))) {
                LogSupport.trace("Added type to superclass \"{0}\" from \"{1}\".", superclassName, referentName);
            } else {
                LogSupport.trace("Excluding type to superclass \"{0}\" from \"{1}\"; the type was already generated.", superclassName, referentName);
            }
            for (ClassDoc interfaceDoc : parent.classDoc.interfaces()) {
                String interfaceName;
                String string2 = interfaceName = interfaceDoc == null ? null : interfaceDoc.qualifiedName();
                if (interfaceName == null) {
                    LogSupport.info("Encountered <null> as implemented interface of \"{0}\".", referentName);
                    continue;
                }
                if (excludedReferences.contains(interfaceName)) {
                    LogSupport.trace("Excluding interface \"{0}\" of \"{1}\"...", interfaceName, referentName);
                    continue;
                }
                if (references.add(new ClassReferenceRenderer(parent, interfaceDoc, "<|.."))) {
                    LogSupport.trace("Added type to interface \"{0}\" from \"{1}\".", interfaceName, referentName);
                    continue;
                }
                LogSupport.debug("Excluding type to interface \"{0}\" from \"{1}\"; the type was already generated.", interfaceName, referentName);
            }
            if (parent.classDoc.containingClass() != null) {
                references.add(new ClassReferenceRenderer(parent, parent.classDoc.containingClass(), "+--"));
            }
            references.addAll(LegacyTag.legacyReferencesFor(parent));
            LinkedHashSet<ClassReferenceRenderer> linkedHashSet = references;
            return linkedHashSet;
        }
    }

    private String guessClassOrInterface() {
        return "<|..".equals(this.reference.type) || "..|>".equals(this.reference.type) ? "interface" : "class";
    }

    protected IndentingPrintWriter writeTypeDeclarationsTo(IndentingPrintWriter out) {
        for (Reference.Side side : new Reference.Side[]{this.reference.from, this.reference.to}) {
            if (!this.diagram.encounteredTypes.add(side.qualifiedName)) {
                LogSupport.trace("Not generating type declaration for \"{0}\"; type was previously encountered in this diagram.", side.qualifiedName);
                continue;
            }
            ClassDoc typeInfo = this.classDoc.findClass(side.qualifiedName);
            if (typeInfo == null) {
                LogSupport.trace("Generating 'unknown' class type declaration for \"{0}\"; we only have a class name type as declaration.", this.name());
                out.append(this.guessClassOrInterface());
                out.whitespace().append(this.parent.nameOf(side.qualifiedName));
                out.whitespace().append("<<(?,orchid)>>").newline();
                continue;
            }
            LogSupport.trace("Generating type declaration for \"{0}\"...", typeInfo.qualifiedName());
            out.append(ClassReferenceRenderer.umlTypeOf(typeInfo));
            out.whitespace().append(this.parent.nameOf(typeInfo.qualifiedName()));
            ClassReferenceRenderer.writeGenericsOf(typeInfo, out);
            if (!this.children.isEmpty()) {
                this.writeChildrenTo(out.whitespace().append("{").newline()).append('}');
            }
            out.newline();
        }
        return out;
    }

    protected boolean isSelfReference() {
        return this.reference.isSelfReference();
    }

    protected void addNote(String note) {
        this.reference = this.reference.addNote(note);
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        this.writeTypeDeclarationsTo(out);
        LogSupport.trace("Generating type: {0}...", this.reference);
        out.append(this.parent.simplifyClassnameWithinPackage(this.reference.from.qualifiedName)).whitespace().append(ClassReferenceRenderer.quoted(this.reference.from.cardinality)).whitespace().append(this.reference.type).whitespace().append(ClassReferenceRenderer.quoted(this.reference.to.cardinality)).whitespace().append(this.parent.simplifyClassnameWithinPackage(this.reference.to.qualifiedName));
        if (!this.reference.notes.isEmpty()) {
            String sep = ": ";
            for (String note : this.reference.notes) {
                out.append(sep).append(note);
                sep = "\\n";
            }
        }
        return out.newline().newline();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.reference);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ClassReferenceRenderer && this.reference.equals(((ClassReferenceRenderer)other).reference);
    }
}

