/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Model;
import nl.talsmasoftware.umldoclet.rendering.AnnotationRenderer;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.FieldRenderer;
import nl.talsmasoftware.umldoclet.rendering.MethodRenderer;
import nl.talsmasoftware.umldoclet.rendering.NoteRenderer;
import nl.talsmasoftware.umldoclet.rendering.PackageRenderer;
import nl.talsmasoftware.umldoclet.rendering.ParentAwareRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class ClassRenderer
extends ParentAwareRenderer {
    protected final ClassDoc classDoc;
    private final String classHyperlink;
    private final Collection<NoteRenderer> notes;

    protected ClassRenderer(Renderer parent, ClassDoc classDoc) {
        super(parent);
        try (GlobalPosition gp = new GlobalPosition((Doc)classDoc);){
            this.classDoc = Objects.requireNonNull(classDoc, "No class documentation provided.");
            this.notes = this.findLegacyNoteTags();
            this.classHyperlink = this.determineClassHyperlink();
            this.addEnumConstants();
            this.addFields();
            this.addConstructors();
            this.addMethods();
        }
    }

    static ClassRenderer create(Renderer parent, ClassDoc classDoc) {
        if (classDoc.isAnnotationType()) {
            return new AnnotationRenderer(parent, classDoc);
        }
        return new ClassRenderer(parent, classDoc);
    }

    private String determineClassHyperlink() {
        if (this.diagram.config.includeHyperlinks()) {
            StringBuilder path = new StringBuilder();
            if (this.diagram.config.imageDirectory() != null) {
                for (int i = ClassRenderer.countPathComponents(this.diagram.config.imageDirectory()); i > 0; --i) {
                    path.append("../");
                }
                path.append(this.classDoc.containingPackage().name().replace('.', '/')).append('/');
            }
            return path.append(this.classDoc.name()).append(".html").toString();
        }
        return null;
    }

    private void addEnumConstants() {
        for (FieldDoc enumConstant : this.classDoc.enumConstants()) {
            this.children.add(new FieldRenderer(this.diagram, enumConstant));
        }
    }

    private void addFields() {
        FieldDoc[] allFields = this.classDoc.fields(false);
        ArrayList<FieldRenderer> regularFields = new ArrayList<FieldRenderer>(allFields.length);
        for (FieldDoc field : allFields) {
            if (field.isStatic()) {
                this.children.add(new FieldRenderer(this.diagram, field));
                continue;
            }
            regularFields.add(new FieldRenderer(this.diagram, field));
        }
        this.children.addAll(regularFields);
    }

    private void addConstructors() {
        for (ConstructorDoc constructor : this.classDoc.constructors(false)) {
            this.children.add(new MethodRenderer(this.diagram, (ExecutableMemberDoc)constructor));
        }
    }

    private void addMethods() {
        MethodDoc[] allMethods = this.classDoc.methods(false);
        ArrayList<MethodRenderer> abstractMethods = new ArrayList<MethodRenderer>(allMethods.length);
        for (MethodDoc method : allMethods) {
            MethodRenderer methodRenderer = new MethodRenderer(this.diagram, (ExecutableMemberDoc)method);
            if (method.isAbstract()) {
                abstractMethods.add(methodRenderer);
                continue;
            }
            this.children.add(methodRenderer);
        }
        this.children.addAll(abstractMethods);
    }

    private Collection<NoteRenderer> findLegacyNoteTags() {
        Tag[] allNotes = this.classDoc.tags("note");
        ArrayList<NoteRenderer> legacyNoteTags = new ArrayList<NoteRenderer>(allNotes.length);
        for (Tag notetag : allNotes) {
            String note = notetag.text();
            if (note == null) continue;
            legacyNoteTags.add(new NoteRenderer(this, note));
        }
        legacyNoteTags.trimToSize();
        return legacyNoteTags;
    }

    protected String umlType() {
        return ClassRenderer.umlTypeOf(this.classDoc);
    }

    protected static String umlTypeOf(ClassDoc classDoc) {
        return classDoc.isEnum() ? "enum" : (classDoc.isInterface() ? "interface" : (classDoc.isAnnotationType() ? "annotation" : (classDoc.isAbstract() ? "abstract class" : "class")));
    }

    protected IndentingPrintWriter writeGenericsTo(IndentingPrintWriter out) {
        return ClassRenderer.writeGenericsOf(this.classDoc, out);
    }

    protected static IndentingPrintWriter writeGenericsOf(ClassDoc classDoc, IndentingPrintWriter out) {
        if (classDoc.typeParameters().length > 0) {
            out.append('<');
            String sep = "";
            for (TypeVariable generic : classDoc.typeParameters()) {
                out.append(sep).append(generic.typeName());
                sep = ", ";
            }
            out.append('>');
        }
        return out;
    }

    protected IndentingPrintWriter writeNotesTo(IndentingPrintWriter out) {
        for (NoteRenderer note : this.notes) {
            note.writeTo(out);
        }
        return out;
    }

    protected String name() {
        return this.nameOf(this.classDoc.qualifiedName());
    }

    protected String nameOf(String qualifiedClassName) {
        String name = qualifiedClassName;
        if (this.parent instanceof DiagramRenderer) {
            name = this.classDoc.name();
        } else if (this.parent instanceof PackageRenderer) {
            name = this.simplifyClassnameWithinPackage(name);
        }
        return name;
    }

    protected String simplifyClassnameWithinPackage(String className) {
        String packageName = this.classDoc.containingPackage().name();
        String packagePrefix = packageName + ".";
        if (!className.startsWith(packagePrefix)) {
            LogSupport.trace("Cannot simplify classname \"{0}\" as it does not belong in package \"{1}\".", className, packageName);
        } else if (className.lastIndexOf(46) >= packagePrefix.length()) {
            LogSupport.trace("Inner-class \"{0}\" within package \"{1}\" could be simplified but will be left as-is because the remaining dot will make plantUML unable to distinguish the outer class from another package.", className, packageName);
        } else if (this.diagram.config.alwaysUseQualifiedClassnames()) {
            LogSupport.debug("Not simplifying classname \"{0}\" to \"{1}\" because doclet parameters told us not to...", className, className.substring(packagePrefix.length()));
        } else {
            String simpleClassname = className.substring(packagePrefix.length());
            LogSupport.trace("Simplifying class name \"{0}\" to \"{1}\" because it is contained in package \"{2}\"...", className, simpleClassname, packageName);
            return simpleClassname;
        }
        return className;
    }

    protected IndentingPrintWriter writeNameTo(IndentingPrintWriter out) {
        this.diagram.encounteredTypes.add(this.classDoc.qualifiedName());
        return out.append(this.name());
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        try (GlobalPosition gp = new GlobalPosition(this.classDoc.position());){
            this.writeNameTo(out.append(this.umlType()).whitespace());
            this.writeGenericsTo(out).whitespace();
            if (Model.isDeprecated((ProgramElementDoc)this.classDoc)) {
                out.append("<<deprecated>>").whitespace();
            }
            if (this.classHyperlink != null) {
                out.append("[[").append(this.classHyperlink).append("]]").whitespace();
            }
            this.writeChildrenTo(out.append('{').newline()).append('}').newline().newline();
            IndentingPrintWriter indentingPrintWriter = this.writeNotesTo(out);
            return indentingPrintWriter;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classDoc.qualifiedName());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && ClassRenderer.class.equals(other.getClass()) && Objects.equals(this.classDoc.qualifiedName(), ((ClassRenderer)other).classDoc.qualifiedName());
    }

    private static int countPathComponents(String path) {
        int count = 0;
        for (String part : path.trim().split("\\s*/\\s*")) {
            if (part.isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

