/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import java.util.Objects;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class CommandRenderer
extends Renderer {
    protected final String command;

    protected CommandRenderer(DiagramRenderer currentDiagram, String command) {
        super(currentDiagram);
        this.command = Objects.requireNonNull(command, "No command provided.");
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter output) {
        LogSupport.trace("Writing command \"{0}\"...", this.command);
        return output.append(this.command).newline();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.command);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof CommandRenderer && Objects.equals(this.command, ((CommandRenderer)other).command);
    }
}

