/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import nl.talsmasoftware.umldoclet.config.UMLDocletConfig;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;
import nl.talsmasoftware.umldoclet.rendering.CommandRenderer;
import nl.talsmasoftware.umldoclet.rendering.PackageRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class DiagramRenderer
extends Renderer {
    protected final UMLDocletConfig config;
    final Set<String> encounteredTypes = new LinkedHashSet<String>();

    public DiagramRenderer(UMLDocletConfig config) {
        super(null);
        this.config = Objects.requireNonNull(config, "No UML doclet configuration provided.");
    }

    public DiagramRenderer addClass(ClassDoc classDoc) {
        try (GlobalPosition gp = new GlobalPosition((Doc)classDoc);){
            DiagramRenderer classDiagram = new DiagramRenderer(this.config);
            classDiagram.children.addAll(this.children);
            classDiagram.children.add(ClassRenderer.create(this, classDoc));
            this.addGlobalCommandsTo(classDiagram.children);
            DiagramRenderer diagramRenderer = classDiagram;
            return diagramRenderer;
        }
    }

    public DiagramRenderer addPackage(PackageDoc packageDoc) {
        try (GlobalPosition gp = new GlobalPosition((Doc)packageDoc);){
            DiagramRenderer packageDiagram = new DiagramRenderer(this.config);
            packageDiagram.children.addAll(this.children);
            packageDiagram.children.add(new PackageRenderer(this, packageDoc));
            this.addGlobalCommandsTo(packageDiagram.children);
            DiagramRenderer diagramRenderer = packageDiagram;
            return diagramRenderer;
        }
    }

    public DiagramRenderer addDependencyDiagram(Object dontKnowYet) {
        return this;
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        out.append("@startuml").newline().newline();
        this.writeChildrenTo(out);
        return out.append("@enduml").newline();
    }

    private void addGlobalCommandsTo(Collection<Renderer> renderers) {
        for (String umlCommand : this.config.umlCommands()) {
            renderers.add(new CommandRenderer(this, umlCommand));
        }
    }
}

