/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Model;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class FieldRenderer
extends Renderer {
    protected final FieldDoc fieldDoc;
    boolean disabled = false;

    protected FieldRenderer(DiagramRenderer diagram, FieldDoc fieldDoc) {
        super(diagram);
        this.fieldDoc = Objects.requireNonNull(fieldDoc, "No field documentation provided.");
    }

    static IndentingPrintWriter writeAccessibility(IndentingPrintWriter out, ProgramElementDoc element) {
        if (element.isStatic()) {
            out.append("{static}").whitespace();
        }
        return element.isPrivate() ? out.append('-') : (element.isProtected() ? out.append('#') : (element.isPackagePrivate() ? out.append('~') : out.append('+')));
    }

    protected boolean includeFieldType() {
        return this.diagram.config.includeFieldTypes() && !this.fieldDoc.isEnumConstant();
    }

    protected boolean includeField() {
        boolean exclude;
        boolean bl = exclude = this.disabled && !this.diagram.config.includeDisabledFields() || this.fieldDoc.isPrivate() && !this.diagram.config.includePrivateFields() || this.fieldDoc.isPackagePrivate() && !this.diagram.config.includePackagePrivateFields() || this.fieldDoc.isProtected() && !this.diagram.config.includeProtectedFields() || this.fieldDoc.isPublic() && !this.diagram.config.includePublicFields() || !this.diagram.config.includeDeprecatedFields() && Model.isDeprecated((ProgramElementDoc)this.fieldDoc) && !Model.isDeprecated((ProgramElementDoc)this.fieldDoc.containingClass());
        if (LogSupport.isTraceEnabled()) {
            String designation = LogSupport.concatLowercaseParts(this.disabled ? "Disabled" : null, Model.isDeprecated((ProgramElementDoc)this.fieldDoc) ? "Deprecated" : null, this.fieldDoc.isStatic() ? "Static" : null, "Field");
            LogSupport.trace("{0} \"{1}\" {2}{3} included.", designation, this.fieldDoc.qualifiedName(), this.fieldDoc.isPrivate() ? "is private and " : (this.fieldDoc.isPackagePrivate() ? "is package private and " : (this.fieldDoc.isProtected() ? "is protected and " : (this.fieldDoc.isPublic() ? "is public and " : ""))), exclude ? "will not be" : "will be");
        }
        return !exclude;
    }

    protected IndentingPrintWriter writeNameTo(IndentingPrintWriter out) {
        return Model.isDeprecated((ProgramElementDoc)this.fieldDoc) ? out.whitespace().append("--").append(this.fieldDoc.name()).append("--").whitespace() : out.append(this.fieldDoc.name());
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        try (GlobalPosition gp = new GlobalPosition((Doc)this.fieldDoc);){
            if (this.includeField()) {
                if (this.disabled) {
                    out.append("' ");
                }
                FieldRenderer.writeAccessibility(out, (ProgramElementDoc)this.fieldDoc);
                this.writeNameTo(out);
                if (this.includeFieldType()) {
                    FieldRenderer.writeTypeTo(out.append(":").whitespace(), this.fieldDoc.type());
                }
                out.newline();
            }
            IndentingPrintWriter indentingPrintWriter = out;
            return indentingPrintWriter;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fieldDoc.qualifiedName());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof FieldRenderer && Objects.equals(this.fieldDoc.qualifiedName(), ((FieldRenderer)other).fieldDoc.qualifiedName());
    }
}

