/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import nl.talsmasoftware.umldoclet.config.UMLDocletConfig;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Reference;
import nl.talsmasoftware.umldoclet.rendering.ClassReferenceRenderer;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;

public enum LegacyTag {
    EXTENDS("<|--", 0),
    IMPLEMENTS("<|..", 0),
    ASSOC("--", 3),
    NAVASSOC("<--", 3),
    DEPEND("<..", 3);

    private final String tagname = this.name().toLowerCase(Locale.ENGLISH);
    private final String umlreference;
    private final int classPos;

    private LegacyTag(String umlreference, int classPos) {
        this.umlreference = umlreference;
        this.classPos = classPos;
    }

    private ClassReferenceRenderer createReferenceFrom(ClassRenderer parent, Tag tag) {
        if (parent != null && tag != null) {
            String referredType;
            String[] parts = tag.text().trim().split("\\s");
            if (this.classPos >= parts.length) {
                LogSupport.warn("No associated class found in legacy @{0} tag \"{1}\".", this.tagname, tag.text());
                return null;
            }
            ClassDoc referredClassDoc = parent.classDoc.findClass(parts[this.classPos].trim());
            String string = referredType = referredClassDoc != null ? referredClassDoc.qualifiedName() : LegacyTag.localNameWithinPackage(parts[this.classPos].trim(), parent.classDoc.containingPackage());
            if (parent.diagram.config.excludedReferences().contains(referredType)) {
                LogSupport.debug("Excluding @{0} tag \"{1}\"; the type is configured as \"excluded\".", this.tagname, referredType);
                return null;
            }
            return new ClassReferenceRenderer(parent, new Reference(Reference.Side.from(referredType, this.emptyToNull(this.classPos == 3 ? parts[2] : null)), this.umlreference, Reference.Side.to(parent.classDoc.qualifiedName(), this.emptyToNull(this.classPos == 3 ? parts[0] : null)), this.emptyToNull(this.classPos == 3 ? parts[1] : null)).canonical());
        }
        return null;
    }

    private static String localNameWithinPackage(String name, PackageDoc packageDoc) {
        if (name != null && packageDoc != null && !name.contains(".")) {
            return packageDoc.name() + "." + name;
        }
        return name;
    }

    private String emptyToNull(String value) {
        value = value != null ? value.trim() : "";
        return value.isEmpty() || "-".equals(value) ? null : value;
    }

    static Collection<ClassReferenceRenderer> legacyReferencesFor(ClassRenderer includedClass) {
        UMLDocletConfig config;
        LinkedHashSet<ClassReferenceRenderer> legacyReferences = new LinkedHashSet<ClassReferenceRenderer>();
        UMLDocletConfig uMLDocletConfig = config = includedClass == null ? null : includedClass.diagram.config;
        if (config != null && config.supportLegacyTags()) {
            for (LegacyTag legacytag : LegacyTag.values()) {
                for (Tag tag : includedClass.classDoc.tags(legacytag.tagname)) {
                    ClassReferenceRenderer refRenderer = legacytag.createReferenceFrom(includedClass, tag);
                    if (refRenderer == null) {
                        LogSupport.trace("Tag @{0} did not result in a type from \"{1}\"...", legacytag.tagname, tag.text());
                        continue;
                    }
                    if (legacyReferences.add(refRenderer)) {
                        LogSupport.trace("Tag @{0} resulted in a \"{1}\" type: {2}.", legacytag.tagname, legacytag.umlreference, refRenderer.reference);
                        continue;
                    }
                    LogSupport.trace("Tag @{0} type already existed: {1}.", legacytag.tagname, refRenderer.reference);
                }
            }
        }
        return legacyReferences;
    }
}

