/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.model.Model;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.FieldRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class MethodRenderer
extends Renderer {
    private static final Set<String> IMPLICIT_ENUM_METHODS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("values()", "valueOf(String)")));
    protected final ExecutableMemberDoc methodDoc;
    boolean disabled = false;

    protected MethodRenderer(DiagramRenderer diagram, ExecutableMemberDoc methodDoc) {
        super(diagram);
        this.methodDoc = Objects.requireNonNull(methodDoc, "No method documentation provided.");
    }

    protected boolean includeMethod() {
        boolean exclude;
        boolean bl = exclude = this.isMethodFromExcludedClass() || this.isConstructor() && !this.diagram.config.includeConstructors() || this.isDefaultAndOnlyConstructor() && !this.diagram.config.includeDefaultConstructors() || this.methodDoc.isPrivate() && !this.diagram.config.includePrivateMethods() || this.methodDoc.isPackagePrivate() && !this.diagram.config.includePackagePrivateMethods() || this.methodDoc.isProtected() && !this.diagram.config.includeProtectedMethods() || this.methodDoc.isPublic() && !this.diagram.config.includePublicMethods() || !this.diagram.config.includeDeprecatedMethods() && Model.isDeprecated((ProgramElementDoc)this.methodDoc) && !Model.isDeprecated((ProgramElementDoc)this.methodDoc.containingClass());
        if (LogSupport.isTraceEnabled()) {
            String designation = LogSupport.concatLowercaseParts(Model.isDeprecated((ProgramElementDoc)this.methodDoc) ? "Deprecated" : null, this.isAbstract() ? "Abstract" : null, this.methodDoc.isStatic() ? "Static" : null, this.isDefaultConstructor() ? "Default" : null, this.isConstructor() ? "Constructor" : "Method");
            LogSupport.trace("{0} \"{1}{2}\" {3}{4}.", designation, this.methodDoc.qualifiedName(), this.methodDoc.flatSignature(), this.methodDoc.isPrivate() ? "is private and " : (this.methodDoc.isPackagePrivate() ? "is package private and " : (this.methodDoc.isProtected() ? "is protected and " : (this.methodDoc.isPublic() ? "is public and " : ""))), exclude ? "will not be included" : "will be included");
        }
        return !exclude;
    }

    protected IndentingPrintWriter writeNameTo(IndentingPrintWriter out) {
        return Model.isDeprecated((ProgramElementDoc)this.methodDoc) ? out.whitespace().append("--").append(this.methodDoc.name()).append("--").whitespace() : out.append(this.methodDoc.name());
    }

    protected IndentingPrintWriter writeParametersTo(IndentingPrintWriter out) {
        if (this.diagram.config.includeMethodParams()) {
            String separator = "";
            for (Parameter parameter : this.methodDoc.parameters()) {
                if (this.diagram.config.includeMethodParamNames()) {
                    out.append(separator).append(parameter.name());
                    if (this.diagram.config.includeMethodParamTypes()) {
                        MethodRenderer.writeTypeTo(out.append(':'), parameter.type());
                    }
                    separator = ", ";
                    continue;
                }
                if (!this.diagram.config.includeMethodParamTypes()) continue;
                MethodRenderer.writeTypeTo(out.append(separator), parameter.type());
                separator = ", ";
            }
        }
        return out;
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        try (GlobalPosition gp = new GlobalPosition(this.methodDoc.position());){
            if (this.includeMethod() && !this.disabled) {
                if (this.isAbstract()) {
                    out.append("{abstract}").whitespace();
                }
                FieldRenderer.writeAccessibility(out, (ProgramElementDoc)this.methodDoc);
                this.writeNameTo(out);
                this.writeParametersTo(out.append('(')).append(')');
                if (this.methodDoc instanceof MethodDoc && this.diagram.config.includeMethodReturntypes()) {
                    MethodRenderer.writeTypeTo(out.append(':').whitespace(), ((MethodDoc)this.methodDoc).returnType());
                }
                IndentingPrintWriter indentingPrintWriter = out.newline();
                return indentingPrintWriter;
            }
            IndentingPrintWriter indentingPrintWriter = out;
            return indentingPrintWriter;
        }
    }

    private boolean isConstructor() {
        return this.methodDoc instanceof ConstructorDoc;
    }

    private boolean isDefaultConstructor() {
        return this.isConstructor() && this.methodDoc.parameters().length == 0;
    }

    private boolean isDefaultAndOnlyConstructor() {
        return this.isDefaultConstructor() && this.methodDoc.containingClass().constructors(false).length == 1;
    }

    private boolean isAbstract() {
        return this.methodDoc instanceof MethodDoc && ((MethodDoc)this.methodDoc).isAbstract();
    }

    private static MethodDoc findMethod(ClassDoc classDoc, String methodName, String flatSignature) {
        for (MethodDoc method : classDoc.methods(false)) {
            if (method == null || !method.name().equals(methodName) || !method.flatSignature().equals(flatSignature)) continue;
            return method;
        }
        return null;
    }

    protected String propertyName() {
        if (!this.methodDoc.isStatic() && this.methodDoc instanceof MethodDoc) {
            String name = this.methodDoc.name();
            int len = name != null ? name.length() : 0;
            char[] propname = null;
            if (len > 3 && name.startsWith("get") && this.methodDoc.parameters().length == 0) {
                propname = name.substring(3).toCharArray();
            } else if (len > 3 && name.startsWith("set") && this.methodDoc.parameters().length == 1) {
                propname = name.substring(3).toCharArray();
            } else if (len > 2 && name.startsWith("is") && this.methodDoc.parameters().length == 0) {
                propname = name.substring(2).toCharArray();
            }
            if (propname != null && propname.length > 0) {
                propname[0] = Character.toLowerCase(propname[0]);
                return String.valueOf(propname);
            }
        }
        return null;
    }

    protected Type propertyType() {
        Type propertyType = null;
        if (this.propertyName() != null) {
            propertyType = this.methodDoc.name().startsWith("set") ? this.methodDoc.parameters()[0].type() : ((MethodDoc)this.methodDoc).returnType();
        }
        return propertyType;
    }

    private boolean isMethodFromExcludedClass() {
        if (this.methodDoc instanceof MethodDoc && !this.diagram.config.includeOverridesFromExcludedReferences()) {
            Type originatingType;
            if (this.isImplicitStaticEnumMethod() && this.diagram.config.excludedReferences().contains(Enum.class.getName())) {
                return true;
            }
            MethodDoc md = (MethodDoc)this.methodDoc;
            Object object = originatingType = md.overriddenType() != null ? md.overriddenType() : md.containingClass();
            while (originatingType instanceof ClassDoc) {
                ClassDoc originatingClass = (ClassDoc)originatingType;
                if (this.diagram.config.excludedReferences().contains(originatingClass.qualifiedName())) {
                    LogSupport.trace("Method \"{0}{1}\" overrides method from excluded type \"{2}\".", this.methodDoc.qualifiedName(), this.methodDoc.flatSignature(), originatingClass.qualifiedName());
                    return true;
                }
                MethodDoc foundMethod = MethodRenderer.findMethod(originatingClass, this.methodDoc.name(), this.methodDoc.flatSignature());
                originatingType = foundMethod != null && !originatingClass.equals(foundMethod.overriddenType()) ? foundMethod.overriddenType() : null;
            }
        }
        return false;
    }

    private boolean isImplicitStaticEnumMethod() {
        if (this.methodDoc.isStatic() && this.methodDoc.containingClass().isEnum() && this.methodDoc instanceof MethodDoc) {
            boolean implitEnumMethod = IMPLICIT_ENUM_METHODS.contains(this.methodDoc.name() + this.methodDoc.flatSignature());
            LogSupport.trace("Method \"{0}{1}\" {2} an implicit static Enum method.", this.methodDoc.qualifiedName(), this.methodDoc.flatSignature(), implitEnumMethod ? "is" : "is not");
            return implitEnumMethod;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.methodDoc.qualifiedName(), this.methodDoc.flatSignature());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof MethodRenderer && Objects.equals(this.methodDoc.qualifiedName(), ((MethodRenderer)other).methodDoc.qualifiedName()) && Objects.equals(this.methodDoc.flatSignature(), ((MethodRenderer)other).methodDoc.flatSignature());
    }
}

