/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import java.util.Objects;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;
import nl.talsmasoftware.umldoclet.rendering.ParentAwareRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class NoteRenderer
extends ParentAwareRenderer {
    protected final String note;
    private final String position = "bottom";

    protected NoteRenderer(Renderer parent, String note) {
        super(parent);
        this.note = Objects.requireNonNull(note, "Note to render may not be <null>!").trim();
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter output) {
        output.append("note");
        if (this.parent instanceof ClassRenderer) {
            output.whitespace().append("bottom").whitespace().append("of").whitespace().append(((ClassRenderer)this.parent).name());
        }
        output.newline().indent().append(this.note).newline();
        return output.append("end note").newline().newline();
    }
}

