/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.util.LinkedHashSet;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.logging.GlobalPosition;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.rendering.ClassPropertyRenderer;
import nl.talsmasoftware.umldoclet.rendering.ClassReferenceRenderer;
import nl.talsmasoftware.umldoclet.rendering.ClassRenderer;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.Renderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public class PackageRenderer
extends Renderer {
    protected final PackageDoc packageDoc;

    protected PackageRenderer(DiagramRenderer diagram, PackageDoc packageDoc) {
        super(diagram);
        try (GlobalPosition gp = new GlobalPosition((Doc)packageDoc);){
            this.packageDoc = Objects.requireNonNull(packageDoc, "No package documentation provided.");
            LinkedHashSet<ClassRenderer> classes = new LinkedHashSet<ClassRenderer>();
            LinkedHashSet<ClassDoc> encounteredClasses = new LinkedHashSet<ClassDoc>();
            for (ClassDoc classDoc : packageDoc.allClasses(false)) {
                if (classDoc == null) {
                    LogSupport.warn("Encountered <null> class doc in package \"{0}\"!", packageDoc.name());
                    continue;
                }
                if (!diagram.config.includeClass(classDoc) || !classes.add(ClassRenderer.create(this, classDoc))) continue;
                encounteredClasses.add(classDoc);
            }
            LinkedHashSet<ClassReferenceRenderer> references = new LinkedHashSet<ClassReferenceRenderer>();
            for (ClassRenderer child : classes) {
                for (ClassReferenceRenderer ref : ClassReferenceRenderer.referencesFor(child)) {
                    if (!references.add(ref)) continue;
                    encounteredClasses.add(ref.classDoc);
                }
            }
            if (diagram.config.usePackageDependencies()) {
                for (ClassRenderer child : classes) {
                    ClassPropertyRenderer.addDiagramDependenciesTo(references, child, encounteredClasses);
                }
            }
            this.children.addAll(classes);
            this.children.addAll(references);
        }
    }

    @Override
    protected IndentingPrintWriter writeTo(IndentingPrintWriter out) {
        try (GlobalPosition pos = new GlobalPosition(this.packageDoc.position());){
            out.append("namespace").whitespace().append(this.packageDoc.name()).whitespace().append('{').newline().newline();
            this.writeChildrenTo(out);
            IndentingPrintWriter indentingPrintWriter = out.append('}').newline().newline();
            return indentingPrintWriter;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.packageDoc.name());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof PackageRenderer && Objects.equals(this.packageDoc.name(), ((PackageRenderer)other).packageDoc.name());
    }
}

