/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import java.util.Iterator;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.rendering.Renderer;

public abstract class ParentAwareRenderer
extends Renderer {
    protected final Renderer parent;
    private volatile Renderer previousSibling;
    private volatile Renderer nextSibling;

    protected ParentAwareRenderer(Renderer parent) {
        super(Objects.requireNonNull(parent, (String)"No parent renderer provided.").diagram);
        this.parent = parent;
    }

    protected Renderer getPreviousSibling() {
        if (this.previousSibling == null) {
            for (Renderer current : this.parent.children) {
                if (this.equals(current)) break;
                this.previousSibling = current;
            }
        }
        return this.previousSibling;
    }

    protected Renderer getNextSibling() {
        if (this.nextSibling == null) {
            Iterator<Renderer> it = this.parent.children.iterator();
            while (it.hasNext()) {
                if (!this.equals(it.next()) || !it.hasNext()) continue;
                this.nextSibling = it.next();
                break;
            }
        }
        return this.nextSibling;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }
}

