/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering;

import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.Type;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.rendering.DiagramRenderer;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;

public abstract class Renderer {
    protected final DiagramRenderer diagram;
    protected final Collection<Renderer> children = new LinkedHashSet<Renderer>();

    protected Renderer(DiagramRenderer diagram) {
        this.diagram = Objects.requireNonNull(this instanceof DiagramRenderer ? (DiagramRenderer)this : diagram, "Diagram renderer is <null>.");
    }

    protected abstract IndentingPrintWriter writeTo(IndentingPrintWriter var1);

    public final Writer writeTo(Writer output) {
        IndentingPrintWriter indentingPrintWriter = output instanceof IndentingPrintWriter ? (IndentingPrintWriter)output : IndentingPrintWriter.wrap(output, this.diagram.config.indentation());
        return this.writeTo(indentingPrintWriter);
    }

    protected IndentingPrintWriter writeChildrenTo(IndentingPrintWriter output) {
        IndentingPrintWriter indented = output.indent();
        for (Renderer child : this.children) {
            child.writeTo(indented);
        }
        return output;
    }

    protected Renderer lastChild() {
        Renderer last = null;
        Iterator<Renderer> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Renderer child;
            last = child = iterator.next();
        }
        return last;
    }

    protected static IndentingPrintWriter writeTypeTo(IndentingPrintWriter out, Type type) {
        if (type != null) {
            Type[] generics;
            out.append(type.typeName());
            ParameterizedType parameterizedType = type.asParameterizedType();
            if (parameterizedType != null && (generics = parameterizedType.typeArguments()).length > 0) {
                out.append("<");
                String sep = "";
                for (Type generic : generics) {
                    Renderer.writeTypeTo(out.append(sep), generic);
                    sep = ", ";
                }
                out.append(">");
            }
            out.append(type.dimension());
        }
        return out;
    }

    public static String quoted(String value) {
        return value == null || value.trim().isEmpty() ? "" : '\"' + value.replaceAll("\"", "\\\"") + '\"';
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public boolean equals(Object other) {
        return this == other || this.getClass().isInstance(other) && Objects.equals(this.children, ((Renderer)other).children);
    }

    public String toString() {
        return this.writeTo(new StringWriter()).toString();
    }
}

