/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.indent;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Objects;

public final class Indentation
implements CharSequence,
Serializable {
    private static final Indentation[] FOUR_SPACES = new Indentation[]{new Indentation(4, ' ', 0), new Indentation(4, ' ', 1), new Indentation(4, ' ', 2), new Indentation(4, ' ', 3), new Indentation(4, ' ', 4)};
    private static final Indentation[] TABS = new Indentation[]{new Indentation(1, '\t', 0), new Indentation(1, '\t', 1), new Indentation(1, '\t', 2), new Indentation(1, '\t', 3), new Indentation(1, '\t', 4)};
    public static Indentation DEFAULT = FOUR_SPACES[0];
    public static Indentation NONE = new Indentation(0, ' ', 0);
    final int width;
    final int level;
    final char ch;
    final char[] buf;

    private Indentation(int width, char ch, int level) {
        this.width = width > 0 ? width : 0;
        this.level = level > 0 ? level : 0;
        this.ch = ch;
        this.buf = new char[this.width * this.level];
        Arrays.fill(this.buf, this.ch);
    }

    public static Indentation tabs(int level) {
        return level < TABS.length ? TABS[Math.max(0, level)] : new Indentation(1, '\t', level);
    }

    public static Indentation spaces(int width, int level) {
        int defaultWidth;
        int n = defaultWidth = Indentation.DEFAULT.ch == ' ' ? Indentation.DEFAULT.width : 4;
        if (width < 0) {
            width = defaultWidth;
        }
        return width == 0 ? NONE : (width == Indentation.FOUR_SPACES[0].width && level < FOUR_SPACES.length ? FOUR_SPACES[Math.max(0, level)] : new Indentation(width, ' ', level));
    }

    private static Indentation resolve(int width, char ch, int level) {
        return width == 0 ? NONE : (ch == ' ' ? Indentation.spaces(width, level) : (width == 1 && ch == '\t' ? Indentation.tabs(level) : new Indentation(width, ch, level)));
    }

    public Indentation increase() {
        return Indentation.resolve(this.width, this.ch, this.level + 1);
    }

    public Indentation decrease() {
        return Indentation.resolve(this.width, this.ch, this.level - 1);
    }

    void writeTo(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer was <null>.").write(this.buf);
    }

    private Object readResolve() {
        return Indentation.resolve(this.width, this.ch, this.level);
    }

    public int hashCode() {
        return Objects.hash(this.width, Character.valueOf(this.ch), this.level);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Indentation && this.width == ((Indentation)other).width && this.ch == ((Indentation)other).ch && this.level == ((Indentation)other).level;
    }

    @Override
    public int length() {
        return this.buf.length;
    }

    @Override
    public char charAt(int index) {
        return this.buf[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().substring(start, end);
    }

    @Override
    public String toString() {
        return String.valueOf(this.buf);
    }
}

