/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.indent;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;

public class IndentingWriter
extends Writer {
    private final Writer delegate;
    private final Indentation indentation;
    private final AtomicBoolean addWhitespace = new AtomicBoolean(false);
    private char lastWritten = (char)10;

    protected IndentingWriter(Writer delegate, Indentation indentation) {
        super((Object)Objects.requireNonNull(delegate, "Delegate writer is required."));
        this.delegate = delegate;
        this.indentation = indentation != null ? indentation : Indentation.DEFAULT;
    }

    private IndentingWriter(Writer delegate, Indentation indentation, char lastWritten, boolean addWhitespace) {
        this(delegate, indentation);
        this.lastWritten = lastWritten;
        this.addWhitespace.set(addWhitespace);
    }

    public static IndentingWriter wrap(Writer delegate, Indentation indentation) {
        return delegate instanceof IndentingWriter ? ((IndentingWriter)delegate).withIndentation(indentation) : new IndentingWriter(delegate, indentation);
    }

    public IndentingWriter withIndentation(Indentation newIndentation) {
        return newIndentation == null || this.indentation.equals(newIndentation) ? this : new IndentingWriter(this.delegate, newIndentation, this.lastWritten, this.addWhitespace.get());
    }

    protected Indentation getIndentation() {
        return this.indentation;
    }

    public IndentingWriter indent() {
        return this.withIndentation(this.getIndentation().increase());
    }

    public IndentingWriter unindent() {
        return this.withIndentation(this.getIndentation().decrease());
    }

    public IndentingWriter whitespace() throws IOException {
        this.addWhitespace.set(true);
        return this;
    }

    private static boolean isEol(char ch) {
        return ch == '\r' || ch == '\n';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.addWhitespace.compareAndSet(true, false) && !Character.isWhitespace(this.lastWritten) && !Character.isWhitespace(cbuf[0])) {
                    this.delegate.write(32);
                }
                for (int i = off; i < len; ++i) {
                    if (IndentingWriter.isEol(this.lastWritten) && !IndentingWriter.isEol(cbuf[i])) {
                        this.indentation.writeTo(this.delegate);
                    }
                    this.delegate.write(cbuf[i]);
                    this.lastWritten = cbuf[i];
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

