/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import nl.talsmasoftware.umldoclet.logging.LogSupport;
import nl.talsmasoftware.umldoclet.rendering.writers.StringBufferingWriter;

public class PlantumlImageWriter
extends StringBufferingWriter {
    private final File directory;
    private final String baseName;
    private final Collection<FileFormat> imageFormats;

    public PlantumlImageWriter(Writer delegate, File directory, String baseName, String ... imageFormats) {
        super(delegate);
        this.directory = directory;
        this.baseName = baseName;
        this.imageFormats = PlantumlImageWriter.parseFileFormats(imageFormats);
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (FileFormat imageFormat : this.imageFormats) {
            File imageFile = new File(this.directory, this.baseName + imageFormat.getFileSuffix());
            LogSupport.info("Generating {0}...", imageFile);
            BufferedOutputStream imageOutput = new BufferedOutputStream(new FileOutputStream(imageFile));
            Throwable throwable = null;
            try {
                new SourceStringReader(this.getBuffer().toString()).generateImage((OutputStream)imageOutput, new FileFormatOption(imageFormat));
                LogSupport.debug("Finished image {0}.", imageFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (imageOutput == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)imageOutput).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)imageOutput).close();
            }
        }
    }

    private static Set<FileFormat> parseFileFormats(String ... imageFormatNames) {
        EnumSet<FileFormat> fileFormats = EnumSet.noneOf(FileFormat.class);
        if (imageFormatNames != null) {
            for (String fileFormatName : imageFormatNames) {
                FileFormat fileFormat = PlantumlImageWriter.fileFormatFromName(fileFormatName);
                if (fileFormat == null) continue;
                fileFormats.add(fileFormat);
            }
        }
        LogSupport.trace("Configured (and recognized) image formats to generate: {0}.", fileFormats);
        return fileFormats;
    }

    private static FileFormat fileFormatFromName(String fileFormatName) {
        if ((fileFormatName = Objects.requireNonNull(fileFormatName, "Configured image format was null!").trim()).startsWith(".")) {
            fileFormatName = fileFormatName.substring(1).trim();
        }
        for (FileFormat fileFormat : FileFormat.values()) {
            if (!fileFormatName.equalsIgnoreCase(fileFormat.name())) continue;
            return fileFormat;
        }
        LogSupport.warn("Unrecognized image format encountered: \"{0}\".", fileFormatName);
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append('{');
        if (this.directory != null) {
            result.append(this.directory.getPath()).append(File.separator);
        }
        result.append(this.baseName);
        if (this.imageFormats.size() == 1) {
            result.append(this.imageFormats.iterator().next().getFileSuffix());
        } else {
            result.append('.').append(this.imageFormats);
        }
        return result.append('}').toString();
    }
}

