/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.plantuml;

import nl.talsmasoftware.umldoclet.logging.LogSupport;

public class PlantumlSupport {
    private static volatile String plantumlVersion = null;

    public static boolean isPlantumlDetected() {
        if (plantumlVersion == null) {
            plantumlVersion = PlantumlSupport.determinePlantumlVersion();
        }
        LogSupport.trace("Detected plantuml version: \"{0}\".", plantumlVersion);
        return !plantumlVersion.isEmpty();
    }

    private static synchronized String determinePlantumlVersion() {
        try {
            String plantumlVersion = Class.forName("net.sourceforge.plantuml.version.Version").getMethod("versionString", new Class[0]).invoke(null, new Object[0]).toString();
            LogSupport.info("Plantuml library version \"{0}\" was detected on the classpath.", plantumlVersion);
            return plantumlVersion;
        }
        catch (LinkageError | ReflectiveOperationException | RuntimeException notFound) {
            LogSupport.info("The plantuml library was not detected on the classpath.", notFound);
            return "";
        }
    }
}

