/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Properties;

public class ParameterDecoratorMapper
extends AbstractDecoratorMapper {
    private String decoratorParameter = null;
    private String paramName = null;
    private String paramValue = null;

    @Override
    public void init(Config config, Properties properties, DecoratorMapper parent) throws InstantiationException {
        super.init(config, properties, parent);
        this.decoratorParameter = properties.getProperty("decorator.parameter", "decorator");
        this.paramName = properties.getProperty("parameter.name", null);
        this.paramValue = properties.getProperty("parameter.value", null);
    }

    @Override
    public Decorator getDecorator(HttpServletRequest request, Page page) {
        Decorator result = null;
        String decoratorParamValue = request.getParameter(this.decoratorParameter);
        if ((this.paramName == null || this.paramValue.equals(request.getParameter(this.paramName))) && decoratorParamValue != null && !decoratorParamValue.trim().equals("")) {
            result = this.getNamedDecorator(request, decoratorParamValue);
        }
        return result == null ? super.getDecorator(request, page) : result;
    }
}

