/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.siteminder;

import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.LockedException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

public class SiteminderAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements Ordered {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProvider == null ? (class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProvider = SiteminderAuthenticationProvider.class$("org.acegisecurity.providers.siteminder.SiteminderAuthenticationProvider")) : class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProvider));
    private UserDetailsService userDetailsService;
    private int order = -1;
    static /* synthetic */ Class class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProvider;

    protected void additionalAuthenticationChecks(UserDetails user, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!user.isEnabled()) {
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "Account disabled"));
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.expired", "Account expired"));
        }
        if (!user.isAccountNonLocked()) {
            throw new LockedException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "Account locked"));
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.credentialsExpired", "Credentials expired"));
        }
    }

    protected void doAfterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService must be set");
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    protected final UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        UserDetails loadedUser;
        try {
            loadedUser = this.getUserDetailsService().loadUserByUsername(username);
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), repositoryProblem);
        }
        if (loadedUser == null) {
            throw new AuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        }
        return loadedUser;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

