/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.logout;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.logout.LogoutHandler;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class SecurityContextLogoutHandler
implements LogoutHandler,
Ordered {
    private boolean invalidateHttpSession = true;
    private int order = Integer.MAX_VALUE;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        HttpSession session;
        Assert.notNull((Object)request, (String)"HttpServletRequest required");
        if (this.invalidateHttpSession && (session = request.getSession(false)) != null) {
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
    }

    public boolean isInvalidateHttpSession() {
        return this.invalidateHttpSession;
    }

    public void setInvalidateHttpSession(boolean invalidateHttpSession) {
        this.invalidateHttpSession = invalidateHttpSession;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

