/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrByteBufferDecodingStream
extends XdrDecodingStream {
    private ByteBuffer buffer;
    private int bufferHighmark;

    public XdrByteBufferDecodingStream(ByteBuffer buffer) {
        if (buffer.limit() < 0 || (buffer.limit() & 3) != 0) {
            throw new IllegalArgumentException("length of encoded data must be a multiple of four and must not be negative");
        }
        this.buffer = buffer;
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return null;
    }

    public int getSenderPort() {
        return 0;
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.buffer.rewind();
        this.bufferHighmark = this.buffer.limit() - 4;
    }

    public void endDecoding() throws OncRpcException, IOException {
        this.bufferHighmark = -4;
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.buffer.position() <= this.bufferHighmark) {
            return this.buffer.getInt();
        }
        throw new OncRpcException(43);
    }

    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        byte[] bytes = new byte[length];
        if (length > 0) {
            if (this.buffer.position() <= this.bufferHighmark - alignedLength + 4) {
                this.buffer.get(bytes);
            } else {
                throw new OncRpcException(43);
            }
        }
        System.out.println(alignedLength + " " + length);
        this.buffer.position(this.buffer.position() + (alignedLength - length));
        return bytes;
    }

    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        if (length > 0) {
            if (this.buffer.position() <= this.bufferHighmark - alignedLength + 4) {
                this.buffer.get(opaque, offset, length);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.buffer.position(this.buffer.position() + (alignedLength - length));
    }
}

