/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrByteBufferEncodingStream
extends XdrEncodingStream {
    private ByteBuffer buffer;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrByteBufferEncodingStream(ByteBuffer buffer) {
        if (buffer.capacity() < 0 || (buffer.capacity() & 3) != 0) {
            throw new IllegalArgumentException("size of buffer must be a multiple of four and must not be negative");
        }
        this.buffer = buffer;
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.bufferHighmark = buffer.capacity() - 4;
    }

    public int getXdrLength() {
        return this.buffer.position();
    }

    public byte[] getXdrData() {
        return this.buffer.array();
    }

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
        this.buffer.clear();
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.buffer.position() > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer.putInt(value);
    }

    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.buffer.position() <= this.bufferHighmark - (length + padding)) {
            this.buffer.put(value, 0, length);
            if (padding != 0) {
                this.buffer.put(paddingZeros, 0, padding);
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

