/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrDecodingStream {
    private String characterEncoding = null;

    public abstract InetAddress getSenderAddress();

    public abstract int getSenderPort();

    public abstract void beginDecoding() throws OncRpcException, IOException;

    public void endDecoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract int xdrDecodeInt() throws OncRpcException, IOException;

    public abstract byte[] xdrDecodeOpaque(int var1) throws OncRpcException, IOException;

    public abstract void xdrDecodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrDecodeOpaque(byte[] opaque) throws OncRpcException, IOException {
        this.xdrDecodeOpaque(opaque, 0, opaque.length);
    }

    public final byte[] xdrDecodeDynamicOpaque() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        byte[] opaque = new byte[length];
        if (length != 0) {
            this.xdrDecodeOpaque(opaque);
        }
        return opaque;
    }

    public final byte[] xdrDecodeByteVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    public final byte[] xdrDecodeByteFixedVector(int length) throws OncRpcException, IOException {
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    public final byte xdrDecodeByte() throws OncRpcException, IOException {
        return (byte)this.xdrDecodeInt();
    }

    public final short xdrDecodeShort() throws OncRpcException, IOException {
        return (short)this.xdrDecodeInt();
    }

    public final long xdrDecodeLong() throws OncRpcException, IOException {
        return ((long)this.xdrDecodeInt() << 32) + ((long)this.xdrDecodeInt() & 0xFFFFFFFFL);
    }

    public final float xdrDecodeFloat() throws OncRpcException, IOException {
        return Float.intBitsToFloat(this.xdrDecodeInt());
    }

    public final double xdrDecodeDouble() throws OncRpcException, IOException {
        return Double.longBitsToDouble(this.xdrDecodeLong());
    }

    public final boolean xdrDecodeBoolean() throws OncRpcException, IOException {
        return this.xdrDecodeInt() != 0;
    }

    public final String xdrDecodeString() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            this.xdrDecodeOpaque(bytes, 0, length);
            return this.characterEncoding != null ? new String(bytes, this.characterEncoding) : new String(bytes);
        }
        return "";
    }

    public final short[] xdrDecodeShortVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    public final short[] xdrDecodeShortFixedVector(int length) throws OncRpcException, IOException {
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    public final int[] xdrDecodeIntVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeInt();
        }
        return value;
    }

    public final int[] xdrDecodeIntFixedVector(int length) throws OncRpcException, IOException {
        int[] value = new int[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeInt();
        }
        return value;
    }

    public final long[] xdrDecodeLongVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        long[] value = new long[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeLong();
        }
        return value;
    }

    public final long[] xdrDecodeLongFixedVector(int length) throws OncRpcException, IOException {
        long[] value = new long[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeLong();
        }
        return value;
    }

    public final float[] xdrDecodeFloatVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    public final float[] xdrDecodeFloatFixedVector(int length) throws OncRpcException, IOException {
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    public final double[] xdrDecodeDoubleVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    public final double[] xdrDecodeDoubleFixedVector(int length) throws OncRpcException, IOException {
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    public final boolean[] xdrDecodeBooleanVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        boolean[] value = new boolean[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeBoolean();
        }
        return value;
    }

    public final boolean[] xdrDecodeBooleanFixedVector(int length) throws OncRpcException, IOException {
        boolean[] value = new boolean[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeBoolean();
        }
        return value;
    }

    public final String[] xdrDecodeStringVector() throws OncRpcException, IOException {
        int length = this.xdrDecodeInt();
        String[] value = new String[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeString();
        }
        return value;
    }

    public final String[] xdrDecodeStringFixedVector(int length) throws OncRpcException, IOException {
        String[] value = new String[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeString();
        }
        return value;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

