/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrEncodingStream {
    private String characterEncoding = null;

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract void xdrEncodeInt(int var1) throws OncRpcException, IOException;

    public abstract void xdrEncodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrEncodeDynamicOpaque(byte[] value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value.length);
        this.xdrEncodeOpaque(value);
    }

    public final void xdrEncodeOpaque(byte[] value) throws OncRpcException, IOException {
        this.xdrEncodeOpaque(value, 0, value.length);
    }

    public final void xdrEncodeOpaque(byte[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        this.xdrEncodeOpaque(value, 0, value.length);
    }

    public final void xdrEncodeByteVector(byte[] value) throws OncRpcException, IOException {
        int length = value.length;
        this.xdrEncodeInt(length);
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                this.xdrEncodeInt(value[i]);
            }
        }
    }

    public final void xdrEncodeByteFixedVector(byte[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                this.xdrEncodeInt(value[i]);
            }
        }
    }

    public final void xdrEncodeByte(byte value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value);
    }

    public final void xdrEncodeShort(short value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value);
    }

    public final void xdrEncodeLong(long value) throws OncRpcException, IOException {
        this.xdrEncodeInt((int)(value >>> 32));
        this.xdrEncodeInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    public final void xdrEncodeFloat(float value) throws OncRpcException, IOException {
        this.xdrEncodeInt(Float.floatToIntBits(value));
    }

    public final void xdrEncodeDouble(double value) throws OncRpcException, IOException {
        this.xdrEncodeLong(Double.doubleToLongBits(value));
    }

    public final void xdrEncodeBoolean(boolean value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value ? 1 : 0);
    }

    public final void xdrEncodeString(String value) throws OncRpcException, IOException {
        if (this.characterEncoding != null) {
            this.xdrEncodeDynamicOpaque(value.getBytes(this.characterEncoding));
        } else {
            this.xdrEncodeDynamicOpaque(value.getBytes());
        }
    }

    public final void xdrEncodeShortVector(short[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeShort(value[i]);
        }
    }

    public final void xdrEncodeShortFixedVector(short[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeShort(value[i]);
        }
    }

    public final void xdrEncodeIntVector(int[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeInt(value[i]);
        }
    }

    public final void xdrEncodeIntFixedVector(int[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeInt(value[i]);
        }
    }

    public final void xdrEncodeLongVector(long[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeLong(value[i]);
        }
    }

    public final void xdrEncodeLongFixedVector(long[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeLong(value[i]);
        }
    }

    public final void xdrEncodeFloatVector(float[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeFloat(value[i]);
        }
    }

    public final void xdrEncodeFloatFixedVector(float[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeFloat(value[i]);
        }
    }

    public final void xdrEncodeDoubleVector(double[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeDouble(value[i]);
        }
    }

    public final void xdrEncodeDoubleFixedVector(double[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeDouble(value[i]);
        }
    }

    public final void xdrEncodeBooleanVector(boolean[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeBoolean(value[i]);
        }
    }

    public final void xdrEncodeBooleanFixedVector(boolean[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeBoolean(value[i]);
        }
    }

    public final void xdrEncodeStringVector(String[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeString(value[i]);
        }
    }

    public final void xdrEncodeStringFixedVector(String[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeString(value[i]);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

