/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrTcpDecodingStream
extends XdrDecodingStream {
    SocketChannel socketChannel;
    private ByteBuffer buffer;
    private int bufferHighmark;
    private int fragmentLength;
    private boolean lastFragment;

    public XdrTcpDecodingStream(SocketChannel socketChannel, int bufferSize) throws IOException {
        this.socketChannel = socketChannel;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.bufferHighmark = -4;
        this.lastFragment = false;
        this.fragmentLength = 0;
    }

    public InetAddress getSenderAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    public int getSenderPort() {
        return this.socketChannel.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socketChannel.socket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.socketChannel.socket().getLocalPort();
    }

    public void beginDecoding() throws OncRpcException, IOException {
        this.fill();
    }

    private void readBuffer(SocketChannel socketChannel, ByteBuffer bytes, int bytesToRead) throws IOException, OncRpcException {
        bytes.clear();
        bytes.limit(bytesToRead);
        while (bytes.hasRemaining()) {
            int bytesRead = socketChannel.read(bytes);
            if (bytesRead > 0) continue;
            throw new OncRpcException(4);
        }
        bytes.rewind();
    }

    private void fill() throws OncRpcException, IOException {
        if (this.fragmentLength <= 0) {
            if (this.lastFragment) {
                throw new OncRpcException(43);
            }
            ByteBuffer bytes = ByteBuffer.allocate(4);
            bytes.order(ByteOrder.BIG_ENDIAN);
            this.readBuffer(this.socketChannel, bytes, 4);
            this.fragmentLength = bytes.getInt();
            if ((this.fragmentLength & Integer.MIN_VALUE) != 0) {
                this.fragmentLength &= Integer.MAX_VALUE;
                this.lastFragment = true;
            } else {
                this.lastFragment = false;
            }
            if ((this.fragmentLength & 3) != 0) {
                throw new IOException("ONC/RPC XDR fragment length is not a multiple of four");
            }
            if (this.fragmentLength == 0 && !this.lastFragment) {
                throw new IOException("empty ONC/RPC XDR fragment which is not a trailing fragment");
            }
        }
        this.buffer.clear();
        if (this.fragmentLength < this.buffer.capacity()) {
            this.readBuffer(this.socketChannel, this.buffer, this.fragmentLength);
            this.bufferHighmark = this.fragmentLength - 4;
            this.fragmentLength = 0;
        } else {
            this.readBuffer(this.socketChannel, this.buffer, this.buffer.capacity());
            this.bufferHighmark = this.buffer.capacity() - 4;
            this.fragmentLength -= this.buffer.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDecoding() throws OncRpcException, IOException {
        try {
            while (!this.lastFragment || this.fragmentLength != 0) {
                this.fill();
            }
        }
        finally {
            this.buffer.clear();
            this.bufferHighmark = -4;
            this.lastFragment = false;
            this.fragmentLength = 0;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socketChannel.close();
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        while (this.buffer.position() > this.bufferHighmark) {
            this.fill();
        }
        return this.buffer.getInt();
    }

    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        int offset = 0;
        byte[] bytes = new byte[length];
        while (this.buffer.position() > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.buffer.position() + 4;
            if (toCopy >= length) {
                this.buffer.get(bytes, offset, length);
                break;
            }
            this.buffer.get(bytes, offset, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.buffer.position(this.buffer.position() + padding);
        return bytes;
    }

    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.buffer.position() > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.buffer.position() + 4;
            if (toCopy >= length) {
                this.buffer.get(opaque, offset, length);
                break;
            }
            this.buffer.get(opaque, offset, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.buffer.position(this.buffer.position() + padding);
    }
}

