/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrTcpEncodingStream
extends XdrEncodingStream {
    SocketChannel socketChannel;
    private ByteBuffer buffer;
    private int bufferHighmark;
    private int bufferFragmentHeaderIndex;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrTcpEncodingStream(SocketChannel socketChannel, int bufferSize) throws IOException {
        this.socketChannel = socketChannel;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.bufferFragmentHeaderIndex = 0;
        this.buffer.position(4);
        this.bufferHighmark = bufferSize - 4;
    }

    public InetAddress getSenderAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    public int getSenderPort() {
        return this.socketChannel.socket().getPort();
    }

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
        this.flush(true, false);
    }

    public void endEncoding(boolean flush) throws OncRpcException, IOException {
        this.flush(true, !flush);
    }

    private void flush(boolean lastFragment, boolean batch) throws OncRpcException, IOException {
        int fragmentLength = this.buffer.position() - this.bufferFragmentHeaderIndex - 4;
        if (lastFragment) {
            fragmentLength |= Integer.MIN_VALUE;
        }
        int pos = this.buffer.position();
        this.buffer.position(this.bufferFragmentHeaderIndex);
        this.buffer.putInt(fragmentLength);
        this.buffer.position(pos);
        if (!lastFragment || !batch || this.buffer.position() >= this.bufferHighmark) {
            this.buffer.flip();
            this.socketChannel.write(this.buffer);
            this.bufferFragmentHeaderIndex = 0;
            this.buffer.clear().position(4);
        } else {
            this.bufferFragmentHeaderIndex = this.buffer.position() - 4;
        }
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socketChannel.close();
    }

    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.buffer.position() > this.bufferHighmark) {
            this.flush(false, false);
        }
        this.buffer.putInt(value);
    }

    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.buffer.position() + 4;
            if (toCopy >= length) {
                this.buffer.put(value, offset, length);
                break;
            }
            this.buffer.put(value, offset, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.flush(false, false);
        }
        this.buffer.put(paddingZeros, 0, padding);
    }
}

