/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrUdpDecodingStream
extends XdrDecodingStream {
    private DatagramSocket socket;
    private InetAddress senderAddress = null;
    private int senderPort = 0;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrUdpDecodingStream(DatagramSocket datagramSocket, int bufferSize) {
        this.socket = datagramSocket;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[bufferSize];
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return this.senderAddress;
    }

    public int getSenderPort() {
        return this.senderPort;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void beginDecoding() throws OncRpcException, IOException {
        DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
        this.socket.receive(packet);
        this.senderAddress = packet.getAddress();
        this.senderPort = packet.getPort();
        this.bufferIndex = 0;
        this.bufferHighmark = packet.getLength() - 4;
    }

    public void endDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex <= this.bufferHighmark) {
            int value = this.buffer[this.bufferIndex++];
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            return value;
        }
        throw new OncRpcException(43);
    }

    public byte[] xdrDecodeOpaque(int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        byte[] bytes = new byte[length];
        if (length > 0) {
            if (this.bufferIndex <= this.bufferHighmark - alignedLength + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, bytes, 0, length);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += alignedLength;
        return bytes;
    }

    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws OncRpcException, IOException {
        int alignedLength = length;
        if ((alignedLength & 3) != 0) {
            alignedLength = (alignedLength & 0xFFFFFFFC) + 4;
        }
        if (length > 0) {
            if (this.bufferIndex <= this.bufferHighmark - alignedLength + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, length);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += alignedLength;
    }
}

