/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcServerCallMessage;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;

public class OncRpcCallInformation {
    public OncRpcServerCallMessage callMessage = new OncRpcServerCallMessage();
    public InetAddress localAddress = null;
    public int localPort = 0;
    public InetAddress peerAddress = null;
    public int peerPort = 0;
    protected OncRpcServerTransport transport;

    public OncRpcCallInformation(OncRpcServerTransport transport) {
        this.transport = transport;
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        this.transport.retrieveCall(call);
    }

    public XdrDecodingStream getXdrDecodingStream() {
        return this.transport.getXdrDecodingStream();
    }

    public void endDecoding() throws OncRpcException, IOException {
        this.transport.endDecoding();
    }

    public void beginEncoding(OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        this.transport.beginEncoding(this, state);
    }

    public void beginEncoding() throws OncRpcException, IOException {
        this.transport.beginEncoding(this, new OncRpcServerReplyMessage(this.callMessage, 0, 0, 0, 0, 0, 0));
    }

    public XdrEncodingStream getXdrEncodingStream() {
        return this.transport.getXdrEncodingStream();
    }

    public void endEncoding() throws OncRpcException, IOException {
        this.transport.endEncoding();
    }

    public void reply(OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        this.transport.reply(this, state, reply);
    }

    public void reply(XdrAble reply) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 0, 0, 0, 0, 0), reply);
    }

    public void failArgumentGarbage() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 4, 0, 0, 0, 0), null);
    }

    public void failProcedureUnavailable() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 3, 0, 0, 0, 0), null);
    }

    public void failProgramUnavailable() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 1, 0, 0, 0, 0), null);
    }

    public void failProgramMismatch(int lowVersion, int highVersion) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 2, 0, lowVersion, highVersion, 0), null);
    }

    public void failSystemError() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 0, 5, 0, 0, 0, 0), null);
    }

    public void failOncRpcVersionMismatch() throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 1, 0, 0, 2, 2, 0), null);
    }

    public void failAuthenticationFailed(int authStatus) throws OncRpcException, IOException {
        this.reply(new OncRpcServerReplyMessage(this.callMessage, 1, 0, 1, 0, 0, authStatus), null);
    }
}

