/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;

public class OncRpcTcpServerTransport
extends OncRpcServerTransport {
    private ServerSocketChannel serverSocketChannel;
    private int bufferSize;
    private final List<OncRpcTcpConnectionServerTransport> openTransports = new LinkedList<OncRpcTcpConnectionServerTransport>();
    protected int transmissionTimeout = 30000;
    private String characterEncoding = null;

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, int program, int version, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, port, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(program, version)}, bufferSize);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, null, port, info, bufferSize);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, InetAddress bindAddr, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        super(dispatcher, port, info);
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.bufferSize = bufferSize;
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().bind(new InetSocketAddress(bindAddr, port));
        if (port == 0) {
            this.port = this.serverSocketChannel.socket().getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.serverSocketChannel != null) {
            ServerSocketChannel deadSocket = this.serverSocketChannel;
            this.serverSocketChannel = null;
            try {
                deadSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        List<OncRpcTcpConnectionServerTransport> list = this.openTransports;
        synchronized (list) {
            for (OncRpcTcpConnectionServerTransport transport : this.openTransports) {
                transport.close();
            }
            this.openTransports.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransport(OncRpcTcpConnectionServerTransport transport) {
        List<OncRpcTcpConnectionServerTransport> list = this.openTransports;
        synchronized (list) {
            this.openTransports.remove(transport);
        }
    }

    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                boolean registered = portmapper.setPort(this.info[idx].program, this.info[idx].version, 6, this.port);
                if (registered) continue;
                throw new OncRpcException(16, "Failed to register by portmap service");
            }
        }
        catch (IOException e) {
            throw new OncRpcException(16);
        }
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.retrieveCall() is abstract and can not be called.");
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrDecodingStream() is abstract and can not be called.");
    }

    protected void endDecoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endDecoding() is abstract and can not be called.");
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrEncodingStream() is abstract and can not be called.");
    }

    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.beginEncoding() is abstract and can not be called.");
    }

    protected void endEncoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endEncoding() is abstract and can not be called.");
    }

    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.reply() is abstract and can not be called.");
    }

    public void listen() {
        Thread listenThread = new Thread("TCP server transport listener thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                while (true) {
                    try {
                        ServerSocketChannel myServerSocket;
                        while ((myServerSocket = OncRpcTcpServerTransport.this.serverSocketChannel) != null) {
                            SocketChannel newSocket = myServerSocket.accept();
                            OncRpcTcpConnectionServerTransport transport = new OncRpcTcpConnectionServerTransport(OncRpcTcpServerTransport.this.dispatcher, newSocket, OncRpcTcpServerTransport.this.info, OncRpcTcpServerTransport.this.bufferSize, OncRpcTcpServerTransport.this, OncRpcTcpServerTransport.this.transmissionTimeout);
                            List list = OncRpcTcpServerTransport.this.openTransports;
                            synchronized (list) {
                                OncRpcTcpServerTransport.this.openTransports.add(transport);
                            }
                            transport.listen();
                        }
                        return;
                    }
                    catch (OncRpcException e) {
                        continue;
                    }
                    catch (IOException e) {
                        if (OncRpcTcpServerTransport.this.serverSocketChannel == null) return;
                        continue;
                    }
                    break;
                }
            }
        };
        listenThread.setDaemon(true);
        listenThread.start();
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

