/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.v4.codegen.OutputModelFactory;
import org.antlr.v4.codegen.model.Action;
import org.antlr.v4.codegen.model.CodeBlockForOuterMostAlt;
import org.antlr.v4.codegen.model.ExceptionClause;
import org.antlr.v4.codegen.model.ModelElement;
import org.antlr.v4.codegen.model.OutputModelObject;
import org.antlr.v4.codegen.model.SrcOp;
import org.antlr.v4.codegen.model.decl.AltLabelStructDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.Decl;
import org.antlr.v4.codegen.model.decl.StructDecl;
import org.antlr.v4.misc.FrequencySet;
import org.antlr.v4.misc.MutableInt;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.parse.GrammarASTAdaptor;
import org.antlr.v4.parse.GrammarTreeVisitor;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.OrderedHashSet;
import org.antlr.v4.runtime.misc.Triple;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.TerminalAST;

public class RuleFunction
extends OutputModelObject {
    public String name;
    public List<String> modifiers;
    public String ctxType;
    public Collection<String> ruleLabels;
    public Collection<String> tokenLabels;
    public ATNState startState;
    public int index;
    public Collection<Attribute> args = null;
    public Rule rule;
    public AltLabelStructDecl[] altToContext;
    public boolean hasLookaheadBlock;
    @ModelElement
    public List<SrcOp> code;
    @ModelElement
    public OrderedHashSet<Decl> locals;
    @ModelElement
    public StructDecl ruleCtx;
    @ModelElement
    public Map<String, AltLabelStructDecl> altLabelCtxs;
    @ModelElement
    public Map<String, Action> namedActions;
    @ModelElement
    public Action finallyAction;
    @ModelElement
    public List<ExceptionClause> exceptions;
    @ModelElement
    public List<SrcOp> postamble;

    public RuleFunction(OutputModelFactory factory, Rule r) {
        super(factory);
        this.name = r.name;
        this.rule = r;
        if (r.modifiers != null && !r.modifiers.isEmpty()) {
            this.modifiers = new ArrayList<String>();
            for (GrammarAST t : r.modifiers) {
                this.modifiers.add(t.getText());
            }
        }
        this.modifiers = Utils.nodesToStrings(r.modifiers);
        this.index = r.index;
        this.ruleCtx = new StructDecl(factory, r);
        this.altToContext = new AltLabelStructDecl[r.getOriginalNumberOfAlts() + 1];
        this.addContextGetters(factory, r);
        if (r.args != null) {
            this.ruleCtx.addDecls(r.args.attributes.values());
            this.args = r.args.attributes.values();
            this.ruleCtx.ctorAttrs = this.args;
        }
        if (r.retvals != null) {
            this.ruleCtx.addDecls(r.retvals.attributes.values());
        }
        if (r.locals != null) {
            this.ruleCtx.addDecls(r.locals.attributes.values());
        }
        this.ruleLabels = r.getElementLabelNames();
        this.tokenLabels = r.getTokenRefs();
        if (r.exceptions != null) {
            this.exceptions = new ArrayList<ExceptionClause>();
            for (GrammarAST e : r.exceptions) {
                ActionAST catchArg = (ActionAST)e.getChild(0);
                ActionAST catchAction = (ActionAST)e.getChild(1);
                this.exceptions.add(new ExceptionClause(factory, catchArg, catchAction));
            }
        }
        this.startState = factory.getGrammar().atn.ruleToStartState[r.index];
    }

    public void addContextGetters(OutputModelFactory factory, Rule r) {
        List<AltAST> altsNoLabels = r.getUnlabeledAltASTs();
        if (altsNoLabels != null) {
            Set<Decl> decls = this.getDeclsForAllElements(altsNoLabels);
            for (Decl decl : decls) {
                this.ruleCtx.addDecl(decl);
            }
        }
        this.altLabelCtxs = new HashMap<String, AltLabelStructDecl>();
        List<Triple<Integer, AltAST, String>> labels = r.getAltLabels();
        if (labels != null) {
            for (Triple triple : labels) {
                Integer altNum = (Integer)triple.a;
                AltAST altAST = (AltAST)triple.b;
                String label = (String)triple.c;
                this.altToContext[altNum.intValue()] = new AltLabelStructDecl(factory, r, altNum, label);
                this.altLabelCtxs.put(label, this.altToContext[altNum]);
                Set<Decl> decls = this.getDeclsForAltElements(altAST);
                for (Decl d : decls) {
                    this.altToContext[altNum].addDecl(d);
                }
            }
        }
    }

    public void fillNamedActions(OutputModelFactory factory, Rule r) {
        if (r.finallyAction != null) {
            this.finallyAction = new Action(factory, r.finallyAction);
        }
        this.namedActions = new HashMap<String, Action>();
        for (String name : r.namedActions.keySet()) {
            ActionAST ast = r.namedActions.get(name);
            this.namedActions.put(name, new Action(factory, ast));
        }
    }

    public Set<Decl> getDeclsForAllElements(List<AltAST> altASTs) {
        HashSet<String> needsList = new HashSet<String>();
        ArrayList<GrammarAST> allRefs = new ArrayList<GrammarAST>();
        for (AltAST ast : altASTs) {
            IntervalSet reftypes = new IntervalSet(56, 65);
            List<GrammarAST> refs = ast.getNodesWithType(reftypes);
            allRefs.addAll(refs);
            FrequencySet<String> altFreq = this.getElementFrequenciesForAlt(ast);
            for (GrammarAST t : refs) {
                String refLabelName = t.getText();
                if (altFreq.count(refLabelName) <= 1) continue;
                needsList.add(refLabelName);
            }
        }
        HashSet<Decl> decls = new HashSet<Decl>();
        for (GrammarAST t : allRefs) {
            String refLabelName = t.getText();
            List<Decl> d = this.getDeclForAltElement(t, refLabelName, needsList.contains(refLabelName));
            decls.addAll(d);
        }
        return decls;
    }

    protected FrequencySet<String> getElementFrequenciesForAlt(AltAST ast) {
        try {
            ElementFrequenciesVisitor visitor = new ElementFrequenciesVisitor(new CommonTreeNodeStream(new GrammarASTAdaptor(), ast));
            visitor.outerAlternative();
            if (visitor.frequencies.size() != 1) {
                this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, new Object[0]);
                return new FrequencySet<String>();
            }
            return visitor.frequencies.peek();
        }
        catch (RecognitionException ex) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
            return new FrequencySet<String>();
        }
    }

    public Set<Decl> getDeclsForAltElements(AltAST altAST) {
        IntervalSet reftypes = new IntervalSet(56, 65);
        List<GrammarAST> refs = altAST.getNodesWithType(reftypes);
        HashSet<Decl> decls = new HashSet<Decl>();
        FrequencySet<String> freq = this.getElementFrequenciesForAlt(altAST);
        for (GrammarAST t : refs) {
            String refLabelName = t.getText();
            boolean needList = freq.count(refLabelName) > 1;
            List<Decl> d = this.getDeclForAltElement(t, refLabelName, needList);
            decls.addAll(d);
        }
        return decls;
    }

    public List<Decl> getDeclForAltElement(GrammarAST t, String refLabelName, boolean needList) {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        if (t.getType() == 56) {
            Rule rref = this.factory.getGrammar().getRule(t.getText());
            String ctxName = this.factory.getGenerator().getTarget().getRuleFunctionContextStructName(rref);
            if (needList) {
                decls.add(new ContextRuleListGetterDecl(this.factory, refLabelName, ctxName));
                decls.add(new ContextRuleListIndexedGetterDecl(this.factory, refLabelName, ctxName));
            } else {
                decls.add(new ContextRuleGetterDecl(this.factory, refLabelName, ctxName));
            }
        } else if (needList) {
            decls.add(new ContextTokenListGetterDecl(this.factory, refLabelName));
            decls.add(new ContextTokenListIndexedGetterDecl(this.factory, refLabelName));
        } else {
            decls.add(new ContextTokenGetterDecl(this.factory, refLabelName));
        }
        return decls;
    }

    public void addLocalDecl(Decl d) {
        if (this.locals == null) {
            this.locals = new OrderedHashSet();
        }
        this.locals.add(d);
        d.isLocal = true;
    }

    public void addContextDecl(String altLabel, Decl d) {
        AltLabelStructDecl altCtx;
        CodeBlockForOuterMostAlt alt = d.getOuterMostAltCodeBlock();
        if (alt != null && this.altLabelCtxs != null && (altCtx = this.altLabelCtxs.get(altLabel)) != null) {
            altCtx.addDecl(d);
            return;
        }
        this.ruleCtx.addDecl(d);
    }

    protected static class ElementFrequenciesVisitor
    extends GrammarTreeVisitor {
        final Deque<FrequencySet<String>> frequencies = new ArrayDeque<FrequencySet<String>>();

        public ElementFrequenciesVisitor(TreeNodeStream input) {
            super(input);
            this.frequencies.push(new FrequencySet());
        }

        protected static FrequencySet<String> combineMax(FrequencySet<String> a, FrequencySet<String> b) {
            FrequencySet<String> result = ElementFrequenciesVisitor.combineAndClip(a, b, 1);
            for (Map.Entry entry : a.entrySet()) {
                ((MutableInt)result.get(entry.getKey())).v = ((MutableInt)entry.getValue()).v;
            }
            for (Map.Entry entry : b.entrySet()) {
                MutableInt slot = (MutableInt)result.get(entry.getKey());
                slot.v = Math.max(slot.v, ((MutableInt)entry.getValue()).v);
            }
            return result;
        }

        protected static FrequencySet<String> combineAndClip(FrequencySet<String> a, FrequencySet<String> b, int clip) {
            int i;
            FrequencySet<String> result = new FrequencySet<String>();
            for (Map.Entry entry : a.entrySet()) {
                for (i = 0; i < ((MutableInt)entry.getValue()).v; ++i) {
                    result.add((String)entry.getKey());
                }
            }
            for (Map.Entry entry : b.entrySet()) {
                for (i = 0; i < ((MutableInt)entry.getValue()).v; ++i) {
                    result.add((String)entry.getKey());
                }
            }
            for (Map.Entry entry : result.entrySet()) {
                ((MutableInt)entry.getValue()).v = Math.min(((MutableInt)entry.getValue()).v, clip);
            }
            return result;
        }

        @Override
        public void tokenRef(TerminalAST ref) {
            this.frequencies.peek().add(ref.getText());
        }

        @Override
        public void ruleRef(GrammarAST ref, ActionAST arg) {
            this.frequencies.peek().add(ref.getText());
        }

        @Override
        protected void enterAlternative(AltAST tree) {
            this.frequencies.push(new FrequencySet());
        }

        @Override
        protected void exitAlternative(AltAST tree) {
            this.frequencies.push(ElementFrequenciesVisitor.combineMax(this.frequencies.pop(), this.frequencies.pop()));
        }

        @Override
        protected void enterElement(GrammarAST tree) {
            this.frequencies.push(new FrequencySet());
        }

        @Override
        protected void exitElement(GrammarAST tree) {
            this.frequencies.push(ElementFrequenciesVisitor.combineAndClip(this.frequencies.pop(), this.frequencies.pop(), 2));
        }

        @Override
        protected void exitSubrule(GrammarAST tree) {
            if (tree.getType() == 78 || tree.getType() == 88) {
                for (Map.Entry entry : this.frequencies.peek().entrySet()) {
                    ((MutableInt)entry.getValue()).v = 2;
                }
            }
        }

        @Override
        protected void enterLexerAlternative(GrammarAST tree) {
            this.frequencies.push(new FrequencySet());
        }

        @Override
        protected void exitLexerAlternative(GrammarAST tree) {
            this.frequencies.push(ElementFrequenciesVisitor.combineMax(this.frequencies.pop(), this.frequencies.pop()));
        }

        @Override
        protected void enterLexerElement(GrammarAST tree) {
            this.frequencies.push(new FrequencySet());
        }

        @Override
        protected void exitLexerElement(GrammarAST tree) {
            this.frequencies.push(ElementFrequenciesVisitor.combineAndClip(this.frequencies.pop(), this.frequencies.pop(), 2));
        }

        @Override
        protected void exitLexerSubrule(GrammarAST tree) {
            if (tree.getType() == 78 || tree.getType() == 88) {
                for (Map.Entry entry : this.frequencies.peek().entrySet()) {
                    ((MutableInt)entry.getValue()).v = 2;
                }
            }
        }
    }
}

