/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.NamedNode;
import org.apache.camel.spi.NodeIdFactory;

public class DefaultNodeIdFactory
implements NodeIdFactory {
    protected static Map<String, AtomicInteger> nodeCounters = new HashMap<String, AtomicInteger>();

    @Override
    public String createId(NamedNode definition) {
        String key = definition.getShortName();
        return key + DefaultNodeIdFactory.getNodeCounter(key).incrementAndGet();
    }

    protected static synchronized AtomicInteger getNodeCounter(String key) {
        AtomicInteger answer = nodeCounters.get(key);
        if (answer == null) {
            answer = new AtomicInteger(0);
            nodeCounters.put(key, answer);
        }
        return answer;
    }

    protected static synchronized void resetAllCounters() {
        for (AtomicInteger counter : nodeCounters.values()) {
            counter.set(0);
        }
    }
}

