/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ExpressionComparator;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.0.0", scheme="mock", title="Mock", syntax="mock:name", producerOnly=true, label="core,testing", lenientProperties=true)
public class MockEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MockEndpoint.class);
    protected volatile Processor reporter;
    private volatile Processor defaultProcessor;
    private volatile Map<Integer, Processor> processors;
    private volatile List<Exchange> receivedExchanges;
    private volatile List<Throwable> failures;
    private volatile List<Runnable> tests;
    private volatile CountDownLatch latch;
    private volatile int expectedMinimumCount;
    private volatile List<?> expectedBodyValues;
    private volatile List<Object> actualBodyValues;
    private volatile Map<String, Object> expectedHeaderValues;
    private volatile Map<String, Object> actualHeaderValues;
    private volatile Map<String, Object> expectedPropertyValues;
    private volatile Map<String, Object> actualPropertyValues;
    private volatile int counter;
    @UriPath(description="Name of mock endpoint")
    @Metadata(required="true")
    private String name;
    @UriParam(label="producer", defaultValue="-1")
    private int expectedCount;
    @UriParam(label="producer", defaultValue="0")
    private long sleepForEmptyTest;
    @UriParam(label="producer", defaultValue="0")
    private long resultWaitTime;
    @UriParam(label="producer", defaultValue="0")
    private long resultMinimumWaitTime;
    @UriParam(label="producer", defaultValue="0")
    private long assertPeriod;
    @UriParam(label="producer", defaultValue="-1")
    private int retainFirst;
    @UriParam(label="producer", defaultValue="-1")
    private int retainLast;
    @UriParam(label="producer")
    private int reportGroup;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean copyOnExchange = true;

    public MockEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.init();
    }

    @Deprecated
    public MockEndpoint(String endpointUri) {
        super(endpointUri);
        this.init();
    }

    public MockEndpoint() {
        this(null);
    }

    public static MockEndpoint resolve(CamelContext context, String uri) {
        return CamelContextHelper.getMandatoryEndpoint(context, uri, MockEndpoint.class);
    }

    public static void assertWait(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        long start2 = System.currentTimeMillis();
        long left = unit.toMillis(timeout);
        long end = start2 + left;
        for (MockEndpoint endpoint : endpoints) {
            if (!endpoint.await(left, TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)("Timeout waiting for endpoints to receive enough messages. " + endpoint.getEndpointUri() + " timed out."));
            }
            left = end - System.currentTimeMillis();
            if (left > 0L) continue;
            left = 0L;
        }
    }

    public static void assertIsSatisfied(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        MockEndpoint.assertWait(timeout, unit, endpoints);
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context) throws InterruptedException {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context, long timeout, TimeUnit unit) throws InterruptedException {
        ObjectHelper.notNull(context, "camelContext");
        ObjectHelper.notNull(unit, "unit");
        Collection<Endpoint> endpoints = context.getEndpoints();
        long millis = unit.toMillis(timeout);
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.setResultWaitTime(millis);
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void setAssertPeriod(CamelContext context, long period) {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.setAssertPeriod(period);
        }
    }

    public static void resetMocks(CamelContext context) {
        ObjectHelper.notNull(context, "camelContext");
        Collection<Endpoint> endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (endpoint instanceof InterceptSendToEndpoint) {
                endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
            }
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.reset();
        }
    }

    public static void expectsMessageCount(int count, MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.setExpectedMessageCount(count);
        }
    }

    @Override
    public List<Exchange> getExchanges() {
        return this.getReceivedExchanges();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from this endpoint");
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultAsyncProducer(this){

            @Override
            public boolean process(Exchange exchange, AsyncCallback callback) {
                MockEndpoint.this.onExchange(exchange);
                callback.done(true);
                return true;
            }
        };
    }

    public void reset() {
        this.init();
    }

    @Handler
    public void handle(Exchange exchange) throws Exception {
        this.onExchange(exchange);
    }

    public void whenExchangeReceived(int index, Processor processor) {
        this.processors.put(index, processor);
    }

    public void whenAnyExchangeReceived(Processor processor) {
        this.defaultProcessor = processor;
    }

    public void returnReplyBody(Expression expression) {
        this.defaultProcessor = ProcessorBuilder.setBody(expression);
    }

    public void returnReplyHeader(String headerName, Expression expression) {
        this.defaultProcessor = ProcessorBuilder.setHeader(headerName, expression);
    }

    public void assertIsSatisfied() throws InterruptedException {
        this.assertIsSatisfied(this.sleepForEmptyTest);
    }

    public void assertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        LOG.info("Asserting: " + this + " is satisfied");
        this.doAssertIsSatisfied(timeoutForEmptyEndpoints);
        if (this.assertPeriod > 0L) {
            Thread.sleep(this.assertPeriod);
            LOG.info("Re-asserting: " + this + " is satisfied after " + this.assertPeriod + " millis");
            this.doAssertIsSatisfied(0L);
        }
    }

    protected void doAssertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        if (this.expectedCount == 0) {
            if (timeoutForEmptyEndpoints > 0L) {
                LOG.debug("Sleeping for: " + timeoutForEmptyEndpoints + " millis to check there really are no messages received");
                Thread.sleep(timeoutForEmptyEndpoints);
            }
            this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
        } else if (this.expectedCount > 0) {
            if (this.expectedCount != this.getReceivedCounter()) {
                this.waitForCompleteLatch();
            }
            this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
        } else if (this.expectedMinimumCount > 0 && this.getReceivedCounter() < this.expectedMinimumCount) {
            this.waitForCompleteLatch();
        }
        if (this.expectedMinimumCount >= 0) {
            int receivedCounter = this.getReceivedCounter();
            this.assertTrue("Received message count " + receivedCounter + ", expected at least " + this.expectedMinimumCount, this.expectedMinimumCount <= receivedCounter);
        }
        for (Runnable test : this.tests) {
            test.run();
        }
        for (Throwable failure : this.failures) {
            if (failure == null) continue;
            LOG.error("Caught on " + this.getEndpointUri() + " Exception: " + failure, failure);
            this.fail("Failed due to caught exception: " + failure);
        }
    }

    public void assertIsNotSatisfied() throws InterruptedException {
        boolean failed = false;
        try {
            this.assertIsSatisfied();
            failed = true;
        }
        catch (AssertionError e) {
            LOG.info("Caught expected failure: " + e);
        }
        if (failed) {
            this.fail("Expected assertion failure but test succeeded!");
        }
    }

    public void assertIsNotSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        boolean failed = false;
        try {
            this.assertIsSatisfied(timeoutForEmptyEndpoints);
            failed = true;
        }
        catch (AssertionError e) {
            LOG.info("Caught expected failure: " + e);
        }
        if (failed) {
            this.fail("Expected assertion failure but test succeeded!");
        }
    }

    public void expectedMessageCount(int expectedCount) {
        this.setExpectedMessageCount(expectedCount);
    }

    public void setAssertPeriod(long period) {
        this.assertPeriod = period;
    }

    public void expectedMinimumMessageCount(int expectedCount) {
        this.setMinimumExpectedMessageCount(expectedCount);
    }

    public void expectedHeaderReceived(String name, Object value) {
        if (this.expectedHeaderValues == null) {
            this.expectedHeaderValues = this.getCamelContext().getHeadersMapFactory().newMap();
            this.expects(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                        Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                        for (Map.Entry entry : MockEndpoint.this.expectedHeaderValues.entrySet()) {
                            String key = (String)entry.getKey();
                            Object expectedValue = entry.getValue();
                            if (expectedValue != null) {
                                MockEndpoint.this.assertTrue("Exchange " + i + " has no headers", exchange.getIn().hasHeaders());
                                boolean hasKey = exchange.getIn().getHeaders().containsKey(key);
                                MockEndpoint.this.assertTrue("No header with name " + key + " found for message: " + i, hasKey);
                            }
                            Object actualValue = exchange.getIn().getHeader(key);
                            actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                            MockEndpoint.this.assertEquals("Header with name " + key + " for message: " + i, expectedValue, actualValue);
                        }
                    }
                }
            });
        }
        this.expectedHeaderValues.put(name, value);
    }

    public void expectedHeaderValuesReceivedInAnyOrder(final String name, final List<?> values) {
        this.expectedMessageCount(values.size());
        this.expects(new Runnable(){

            @Override
            public void run() {
                CopyOnWriteArraySet actualHeaderValues = new CopyOnWriteArraySet(values);
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                    Object actualValue = exchange.getIn().getHeader(name);
                    for (Object expectedValue : actualHeaderValues) {
                        actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                        actualHeaderValues.remove(actualValue);
                    }
                }
                MockEndpoint.this.assertTrue("Expected " + values.size() + " headers with key[" + name + "], received " + (values.size() - actualHeaderValues.size()) + " headers. Expected header values: " + actualHeaderValues, actualHeaderValues.isEmpty());
            }
        });
    }

    public void expectedHeaderValuesReceivedInAnyOrder(String name, Object ... values) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.addAll(Arrays.asList(values));
        this.expectedHeaderValuesReceivedInAnyOrder(name, valueList);
    }

    public void expectedPropertyReceived(String name, Object value) {
        if (this.expectedPropertyValues == null) {
            this.expectedPropertyValues = new HashMap<String, Object>();
        }
        this.expectedPropertyValues.put(name, value);
        this.expects(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                    for (Map.Entry entry : MockEndpoint.this.expectedPropertyValues.entrySet()) {
                        String key = (String)entry.getKey();
                        Object expectedValue = entry.getValue();
                        if (expectedValue != null) {
                            MockEndpoint.this.assertTrue("Exchange " + i + " has no properties", !exchange.getProperties().isEmpty());
                            boolean hasKey = exchange.getProperties().containsKey(key);
                            MockEndpoint.this.assertTrue("No property with name " + key + " found for message: " + i, hasKey);
                        }
                        Object actualValue = exchange.getProperty(key);
                        actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                        MockEndpoint.this.assertEquals("Property with name " + key + " for message: " + i, expectedValue, actualValue);
                    }
                }
            }
        });
    }

    public void expectedPropertyValuesReceivedInAnyOrder(final String name, final List<?> values) {
        this.expectedMessageCount(values.size());
        this.expects(new Runnable(){

            @Override
            public void run() {
                CopyOnWriteArraySet actualPropertyValues = new CopyOnWriteArraySet(values);
                for (int i = 0; i < MockEndpoint.this.getReceivedExchanges().size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                    Object actualValue = exchange.getProperty(name);
                    for (Object expectedValue : actualPropertyValues) {
                        actualValue = MockEndpoint.this.extractActualValue(exchange, actualValue, expectedValue);
                        actualPropertyValues.remove(actualValue);
                    }
                }
                MockEndpoint.this.assertTrue("Expected " + values.size() + " properties with key[" + name + "], received " + (values.size() - actualPropertyValues.size()) + " properties. Expected property values: " + actualPropertyValues, actualPropertyValues.isEmpty());
            }
        });
    }

    public void expectedPropertyValuesReceivedInAnyOrder(String name, Object ... values) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        valueList.addAll(Arrays.asList(values));
        this.expectedPropertyValuesReceivedInAnyOrder(name, valueList);
    }

    public void expectedBodiesReceived(List<?> bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList<Object>();
        this.expects(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + i, exchange != null);
                    Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                    Object actualBody = null;
                    if (i < MockEndpoint.this.actualBodyValues.size()) {
                        actualBody = MockEndpoint.this.actualBodyValues.get(i);
                    }
                    actualBody = MockEndpoint.this.extractActualValue(exchange, actualBody, expectedBody);
                    MockEndpoint.this.assertEquals("Body of message: " + i, expectedBody, actualBody);
                }
            }
        });
    }

    private Object extractActualValue(Exchange exchange, Object actualValue, Object expectedValue) {
        if (actualValue == null) {
            return null;
        }
        if (actualValue instanceof Expression) {
            Class clazz = Object.class;
            if (expectedValue != null) {
                clazz = expectedValue.getClass();
            }
            actualValue = ((Expression)actualValue).evaluate(exchange, clazz);
        } else if (actualValue instanceof Predicate) {
            actualValue = ((Predicate)actualValue).matches(exchange);
        } else if (expectedValue != null) {
            String from = actualValue.getClass().getName();
            String to = expectedValue.getClass().getName();
            actualValue = this.getCamelContext().getTypeConverter().convertTo(expectedValue.getClass(), exchange, actualValue);
            this.assertTrue("There is no type conversion possible from " + from + " to " + to, actualValue != null);
        }
        return actualValue;
    }

    public void expectedMessagesMatches(Predicate ... predicates) {
        for (int i = 0; i < predicates.length; ++i) {
            final int messageIndex = i;
            final Predicate predicate = predicates[i];
            AssertionClause clause = new AssertionClause(this){

                @Override
                public void run() {
                    this.addPredicate(predicate);
                    this.applyAssertionOn(MockEndpoint.this, messageIndex, MockEndpoint.this.assertExchangeReceived(messageIndex));
                }
            };
            this.expects(clause);
        }
    }

    public void expectedBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        this.expectedBodiesReceived(bodyList);
    }

    public AssertionClause expectedBodyReceived() {
        this.expectedMessageCount(1);
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                Exchange exchange = MockEndpoint.this.getReceivedExchange(0);
                MockEndpoint.this.assertTrue("No exchange received for counter: 0", exchange != null);
                Object actualBody = exchange.getIn().getBody();
                Expression exp = this.createExpression(MockEndpoint.this.getCamelContext());
                Object expectedBody = exp.evaluate(exchange, Object.class);
                MockEndpoint.this.assertEquals("Body of message: 0", expectedBody, actualBody);
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectedBodiesReceivedInAnyOrder(List<?> bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList<Object>();
        this.expects(new Runnable(){

            @Override
            public void run() {
                ArrayList actualBodyValuesSet = new ArrayList(MockEndpoint.this.actualBodyValues);
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchange(i);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + i, exchange != null);
                    Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                    MockEndpoint.this.assertTrue("Message with body " + expectedBody + " was expected but not found in " + actualBodyValuesSet, actualBodyValuesSet.remove(expectedBody));
                }
            }
        });
    }

    public void expectedBodiesReceivedInAnyOrder(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        bodyList.addAll(Arrays.asList(bodies));
        this.expectedBodiesReceivedInAnyOrder(bodyList);
    }

    public void expectedFileExists(String name) {
        this.expectedFileExists(name, null);
    }

    public void expectedFileExists(final String name, final String content) {
        final File file = new File(FileUtil.normalizePath(name));
        this.expects(new Runnable(){

            @Override
            public void run() {
                long timeout = System.currentTimeMillis() + 5000L;
                boolean stop2 = false;
                while (!stop2 && !file.exists()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    stop2 = System.currentTimeMillis() > timeout;
                }
                MockEndpoint.this.assertTrue("The file should exists: " + name, file.exists());
                if (content != null) {
                    String body = MockEndpoint.this.getCamelContext().getTypeConverter().convertTo(String.class, file);
                    MockEndpoint.this.assertEquals("Content of file: " + name, content, body);
                }
            }
        });
    }

    public void expectedExchangePattern(final ExchangePattern exchangePattern) {
        this.expectedMessagesMatches(new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                return exchange.getPattern().equals((Object)exchangePattern);
            }
        });
    }

    public void expectsAscending(final Expression expression) {
        this.expects(new Runnable(){

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesAscending(expression);
            }
        });
    }

    public AssertionClause expectsAscending() {
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesAscending(this.createExpression(MockEndpoint.this.getCamelContext()));
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectsDescending(final Expression expression) {
        this.expects(new Runnable(){

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesDescending(expression);
            }
        });
    }

    public AssertionClause expectsDescending() {
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                MockEndpoint.this.assertMessagesDescending(this.createExpression(MockEndpoint.this.getCamelContext()));
            }
        };
        this.expects(clause);
        return clause;
    }

    public void expectsNoDuplicates(final Expression expression) {
        this.expects(new Runnable(){

            @Override
            public void run() {
                MockEndpoint.this.assertNoDuplicates(expression);
            }
        });
    }

    public AssertionClause expectsNoDuplicates() {
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                MockEndpoint.this.assertNoDuplicates(this.createExpression(MockEndpoint.this.getCamelContext()));
            }
        };
        this.expects(clause);
        return clause;
    }

    public void assertMessagesAscending(Expression expression) {
        this.assertMessagesSorted(expression, true);
    }

    public void assertMessagesDescending(Expression expression) {
        this.assertMessagesSorted(expression, false);
    }

    protected void assertMessagesSorted(Expression expression, boolean ascending) {
        String type = ascending ? "ascending" : "descending";
        ExpressionComparator comparator = new ExpressionComparator(expression);
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 1; i < list.size(); ++i) {
            Exchange e2;
            int j = i - 1;
            Exchange e1 = list.get(j);
            int result = comparator.compare(e1, e2 = list.get(i));
            if (result == 0) {
                this.fail("Messages not " + type + ". Messages" + j + " and " + i + " are equal with value: " + expression.evaluate(e1, Object.class) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            if (!ascending) {
                result *= -1;
            }
            if (result <= 0) continue;
            this.fail("Messages not " + type + ". Message " + j + " has value: " + expression.evaluate(e1, Object.class) + " and message " + i + " has value: " + expression.evaluate(e2, Object.class) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
        }
    }

    public void assertNoDuplicates(Expression expression) {
        HashMap<Object, Exchange> map = new HashMap<Object, Exchange>();
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 0; i < list.size(); ++i) {
            Exchange e2 = list.get(i);
            Object key = expression.evaluate(e2, Object.class);
            Exchange e1 = (Exchange)map.get(key);
            if (e1 != null) {
                this.fail("Duplicate message found on message " + i + " has value: " + key + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            map.put(key, e2);
        }
    }

    public void expects(Runnable runnable) {
        this.tests.add(runnable);
    }

    public AssertionClause message(final int messageIndex) {
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                this.applyAssertionOn(MockEndpoint.this, messageIndex, MockEndpoint.this.assertExchangeReceived(messageIndex));
            }
        };
        this.expects(clause);
        return clause;
    }

    public AssertionClause allMessages() {
        AssertionClause clause = new AssertionClause(this){

            @Override
            public void run() {
                List<Exchange> list = MockEndpoint.this.getReceivedExchanges();
                int index = 0;
                for (Exchange exchange : list) {
                    this.applyAssertionOn(MockEndpoint.this, index++, exchange);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public Exchange assertExchangeReceived(int index) {
        int count = this.getReceivedCounter();
        this.assertTrue("Not enough messages received. Was: " + count, count > index);
        return this.getReceivedExchange(index);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public int getReceivedCounter() {
        return this.counter;
    }

    public List<Exchange> getReceivedExchanges() {
        return this.receivedExchanges;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public long getSleepForEmptyTest() {
        return this.sleepForEmptyTest;
    }

    public void setSleepForEmptyTest(long sleepForEmptyTest) {
        this.sleepForEmptyTest = sleepForEmptyTest;
    }

    public long getResultWaitTime() {
        return this.resultWaitTime;
    }

    public void setResultWaitTime(long resultWaitTime) {
        this.resultWaitTime = resultWaitTime;
    }

    public void setResultMinimumWaitTime(long resultMinimumWaitTime) {
        this.resultMinimumWaitTime = resultMinimumWaitTime;
    }

    @Deprecated
    public void setMinimumResultWaitTime(long resultMinimumWaitTime) {
        this.setResultMinimumWaitTime(resultMinimumWaitTime);
    }

    public void setExpectedCount(int expectedCount) {
        this.setExpectedMessageCount(expectedCount);
    }

    public void setExpectedMessageCount(int expectedCount) {
        this.expectedCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(expectedCount);
    }

    public void setMinimumExpectedMessageCount(int expectedCount) {
        this.expectedMinimumCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(this.expectedMinimumCount);
    }

    public Processor getReporter() {
        return this.reporter;
    }

    public void setReporter(Processor reporter) {
        this.reporter = reporter;
    }

    public void setRetainFirst(int retainFirst) {
        this.retainFirst = retainFirst;
    }

    public void setRetainLast(int retainLast) {
        this.retainLast = retainLast;
    }

    public int isReportGroup() {
        return this.reportGroup;
    }

    public void setReportGroup(int reportGroup) {
        this.reportGroup = reportGroup;
    }

    public boolean isCopyOnExchange() {
        return this.copyOnExchange;
    }

    public void setCopyOnExchange(boolean copyOnExchange) {
        this.copyOnExchange = copyOnExchange;
    }

    private void init() {
        this.expectedCount = -1;
        this.counter = 0;
        this.defaultProcessor = null;
        this.processors = new HashMap<Integer, Processor>();
        this.receivedExchanges = new CopyOnWriteArrayList<Exchange>();
        this.failures = new CopyOnWriteArrayList<Throwable>();
        this.tests = new CopyOnWriteArrayList<Runnable>();
        this.latch = null;
        this.sleepForEmptyTest = 0L;
        this.resultWaitTime = 0L;
        this.resultMinimumWaitTime = 0L;
        this.assertPeriod = 0L;
        this.expectedMinimumCount = -1;
        this.expectedBodyValues = null;
        this.actualBodyValues = new ArrayList<Object>();
        this.expectedHeaderValues = null;
        this.actualHeaderValues = null;
        this.expectedPropertyValues = null;
        this.actualPropertyValues = null;
        this.retainFirst = -1;
        this.retainLast = -1;
    }

    protected synchronized void onExchange(Exchange exchange) {
        try {
            if (this.reporter != null) {
                this.reporter.process(exchange);
            }
            Exchange copy = exchange;
            if (this.copyOnExchange) {
                copy = ExchangeHelper.createCopy(exchange, true);
            }
            this.performAssertions(exchange, copy);
        }
        catch (Throwable e) {
            this.failures.add(e);
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    protected void performAssertions(Exchange exchange, Exchange copy) throws Exception {
        Processor processor;
        Message in = copy.getIn();
        Object actualBody = in.getBody();
        if (this.expectedHeaderValues != null) {
            if (this.actualHeaderValues == null) {
                this.actualHeaderValues = this.getCamelContext().getHeadersMapFactory().newMap();
            }
            if (in.hasHeaders()) {
                this.actualHeaderValues.putAll(in.getHeaders());
            }
        }
        if (this.expectedPropertyValues != null) {
            if (this.actualPropertyValues == null) {
                this.actualPropertyValues = this.getCamelContext().getHeadersMapFactory().newMap();
            }
            this.actualPropertyValues.putAll(copy.getProperties());
        }
        if (this.expectedBodyValues != null) {
            int index = this.actualBodyValues.size();
            if (this.expectedBodyValues.size() > index) {
                Object body;
                Object expectedBody = this.expectedBodyValues.get(index);
                if (expectedBody != null && (body = in.getBody(expectedBody.getClass())) != null) {
                    actualBody = body;
                }
                this.actualBodyValues.add(actualBody);
            }
        }
        if (LOG.isDebugEnabled()) {
            String msg = this.getEndpointUri() + " >>>> " + this.counter + " : " + copy + " with body: " + actualBody;
            if (copy.getIn().hasHeaders()) {
                msg = msg + " and headers:" + copy.getIn().getHeaders();
            }
            LOG.debug(msg);
        }
        copy.setProperty("CamelReceivedTimestamp", new Date());
        this.addReceivedExchange(copy);
        ++this.counter;
        Processor processor2 = processor = this.processors.get(this.getReceivedCounter()) != null ? this.processors.get(this.getReceivedCounter()) : this.defaultProcessor;
        if (processor != null) {
            try {
                processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
        }
    }

    protected void addReceivedExchange(Exchange copy) {
        if (this.retainFirst != 0 || this.retainLast != 0) {
            if (this.retainFirst < 0 && this.retainLast < 0) {
                this.receivedExchanges.add(copy);
            } else if (this.retainFirst > 0 && this.counter < this.retainFirst) {
                this.receivedExchanges.add(copy);
            } else if (this.retainLast > 0) {
                int index = this.receivedExchanges.size() - this.retainLast;
                if (index >= 0 && (this.retainFirst <= 0 || this.retainFirst <= index)) {
                    this.receivedExchanges.remove(index);
                }
                this.receivedExchanges.add(copy);
            }
        }
    }

    protected void waitForCompleteLatch() throws InterruptedException {
        if (this.latch == null) {
            this.fail("Should have a latch!");
        }
        StopWatch watch = new StopWatch();
        this.waitForCompleteLatch(this.resultWaitTime);
        long delta = watch.taken();
        LOG.debug("Took {} millis to complete latch", (Object)delta);
        if (this.resultMinimumWaitTime > 0L && delta < this.resultMinimumWaitTime) {
            this.fail("Expected minimum " + this.resultMinimumWaitTime + " millis waiting on the result, but was faster with " + delta + " millis.");
        }
    }

    protected void waitForCompleteLatch(long timeout) throws InterruptedException {
        long waitTime = timeout == 0L ? 10000L : timeout;
        LOG.debug("Waiting on the latch for: " + timeout + " millis");
        this.latch.await(waitTime, TimeUnit.MILLISECONDS);
    }

    protected void assertEquals(String message, Object expectedValue, Object actualValue) {
        if (!ObjectHelper.equal(expectedValue, actualValue)) {
            this.fail(message + ". Expected: <" + expectedValue + "> but was: <" + actualValue + ">");
        }
    }

    protected void assertTrue(String message, boolean predicate) {
        if (!predicate) {
            this.fail(message);
        }
    }

    protected void fail(Object message) {
        if (LOG.isDebugEnabled()) {
            List<Exchange> list = this.getReceivedExchanges();
            int index = 0;
            for (Exchange exchange : list) {
                LOG.debug("{} failed and received[{}]: {}", this.getEndpointUri(), ++index, exchange);
            }
        }
        throw new AssertionError((Object)(this.getEndpointUri() + " " + message));
    }

    public int getExpectedMinimumCount() {
        return this.expectedMinimumCount;
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latch != null) {
            return this.latch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    private Exchange getReceivedExchange(int index) {
        if (index <= this.receivedExchanges.size() - 1) {
            return this.receivedExchanges.get(index);
        }
        return null;
    }
}

