/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.ThreadPoolProfile;

public class ThreadPoolProfileBuilder {
    private final ThreadPoolProfile profile;

    public ThreadPoolProfileBuilder(String id) {
        this.profile = new ThreadPoolProfile(id);
    }

    public ThreadPoolProfileBuilder(String id, ThreadPoolProfile origProfile) {
        this.profile = origProfile.clone();
        this.profile.setId(id);
    }

    public ThreadPoolProfileBuilder defaultProfile(Boolean defaultProfile) {
        this.profile.setDefaultProfile(defaultProfile);
        return this;
    }

    public ThreadPoolProfileBuilder poolSize(Integer poolSize) {
        this.profile.setPoolSize(poolSize);
        return this;
    }

    public ThreadPoolProfileBuilder maxPoolSize(Integer maxPoolSize) {
        this.profile.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadPoolProfileBuilder keepAliveTime(Long keepAliveTime, TimeUnit timeUnit) {
        this.profile.setKeepAliveTime(keepAliveTime);
        this.profile.setTimeUnit(timeUnit);
        return this;
    }

    public ThreadPoolProfileBuilder keepAliveTime(Long keepAliveTime) {
        this.profile.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolProfileBuilder maxQueueSize(Integer maxQueueSize) {
        if (maxQueueSize != null) {
            this.profile.setMaxQueueSize(maxQueueSize);
        }
        return this;
    }

    public ThreadPoolProfileBuilder allowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
        this.profile.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        return this;
    }

    public ThreadPoolProfileBuilder rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.profile.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ThreadPoolProfile build() {
        return this.profile;
    }
}

