/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class NonReentrantLock
implements Lock,
Serializable {
    static final long serialVersionUID = 1L;
    final Sync sync = new Sync();

    @Override
    public void lock() {
        this.sync.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryLock();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.sync.tryLock(time, unit);
    }

    @Override
    public void unlock() {
        this.sync.unlock();
    }

    @Override
    public Condition newCondition() {
        return this.sync.newCondition();
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public boolean isLocked() {
        return this.sync.isLocked();
    }

    public Thread getOwner() {
        return this.sync.getOwner();
    }

    public boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public boolean hasQueuedThread(Thread thread) {
        return this.sync.isQueued(thread);
    }

    public int getQueueLength() {
        return this.sync.getQueueLength();
    }

    public Collection<Thread> getQueuedThreads() {
        return this.sync.getQueuedThreads();
    }

    public boolean hasWaiters(Condition condition) {
        Objects.requireNonNull(condition);
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.hasWaiters((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public int getWaitQueueLength(Condition condition) {
        Objects.requireNonNull(condition);
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitQueueLength((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public Collection<Thread> getWaitingThreads(Condition condition) {
        Objects.requireNonNull(condition);
        if (!(condition instanceof AbstractQueuedSynchronizer.ConditionObject)) {
            throw new IllegalArgumentException("not owner");
        }
        return this.sync.getWaitingThreads((AbstractQueuedSynchronizer.ConditionObject)condition);
    }

    public String toString() {
        Thread o = this.sync.getOwner();
        String status2 = o == null ? "[Unlocked]" : "[Locked by thread " + o.getName() + "]";
        return super.toString() + status2;
    }

    static final class Sync
    extends AbstractQueuedSynchronizer
    implements Lock,
    Serializable {
        static final long serialVersionUID = 1L;
        static final int UNLOCKED = 0;
        static final int LOCKED = 1;

        Sync() {
        }

        @Override
        public void lock() {
            this.acquire(1);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.acquireInterruptibly(1);
        }

        @Override
        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.tryAcquireNanos(1, unit.toNanos(time));
        }

        @Override
        public void unlock() {
            this.release(0);
        }

        @Override
        public Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        @Override
        protected boolean tryAcquire(int acquires) {
            if (this.getState() == 0 && this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int releases) {
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.isLocked() && this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        public boolean isLocked() {
            return this.getState() == 1;
        }

        public Thread getOwner() {
            return this.getExclusiveOwnerThread();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.setState(0);
        }
    }
}

