/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Method;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ProxyInstantiationException;
import org.apache.camel.Service;
import org.apache.camel.builder.DefaultFluentProducerTemplate;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.SubscribeMethodProcessor;
import org.apache.camel.processor.DeferServiceFactory;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelPostProcessorHelper
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelPostProcessorHelper.class);
    @XmlTransient
    private CamelContext camelContext;

    public CamelPostProcessorHelper() {
    }

    public CamelPostProcessorHelper(CamelContext camelContext) {
        this.setCamelContext(camelContext);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.getCamelContext().getName().equals(context);
    }

    public void consumerInjection(Method method, Object bean, String beanName) {
        Consume consume = method.getAnnotation(Consume.class);
        if (consume != null && this.matchContext(consume.context())) {
            LOG.debug("Creating a consumer for: " + consume);
            this.subscribeMethod(method, bean, beanName, consume.uri(), consume.ref(), consume.property(), consume.predicate());
        }
    }

    public void subscribeMethod(Method method, Object bean, String beanName, String endpointUri, String endpointName, String endpointProperty, String predicate) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointName, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            boolean multipleConsumer = false;
            if (endpoint instanceof MultipleConsumersSupport) {
                multipleConsumer = ((MultipleConsumersSupport)((Object)endpoint)).isMultipleConsumersSupported();
            }
            try {
                SubscribeMethodProcessor processor = this.getConsumerProcessor(endpoint);
                if (multipleConsumer || processor == null) {
                    processor = new SubscribeMethodProcessor(endpoint);
                    endpoint.getCamelContext().addService(processor, true);
                    processor.addMethod(bean, method, endpoint, predicate);
                    Consumer consumer = endpoint.createConsumer(processor);
                    this.startService(consumer, endpoint.getCamelContext(), bean, beanName);
                } else {
                    processor.addMethod(bean, method, endpoint, predicate);
                }
                if (predicate != null) {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {} with predicate: {}", method, endpoint, predicate);
                } else {
                    LOG.debug("Subscribed method: {} to consume from endpoint: {}", (Object)method, (Object)endpoint);
                }
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    protected void startService(Service service, CamelContext camelContext, Object bean, String beanName) throws Exception {
        if (camelContext != null) {
            camelContext.deferStartService(service, true);
        } else {
            ServiceHelper.startService(service);
        }
        boolean singleton = this.isSingleton(bean, beanName);
        if (!singleton) {
            LOG.debug("Service is not singleton so you must remember to stop it manually {}", (Object)service);
        }
    }

    protected SubscribeMethodProcessor getConsumerProcessor(Endpoint endpoint) {
        Set<SubscribeMethodProcessor> processors = endpoint.getCamelContext().hasServices(SubscribeMethodProcessor.class);
        return processors.stream().filter(s -> s.getEndpoint() == endpoint).findFirst().orElse(null);
    }

    public Endpoint getEndpointInjection(Object bean, String uri, String name, String propertyName, String injectionPointName, boolean mandatory) {
        if (ObjectHelper.isEmpty(uri) && ObjectHelper.isEmpty(name)) {
            return this.doGetEndpointInjection(bean, propertyName, injectionPointName);
        }
        return this.doGetEndpointInjection(uri, name, injectionPointName, mandatory);
    }

    private Endpoint doGetEndpointInjection(String uri, String name, String injectionPointName, boolean mandatory) {
        return CamelContextHelper.getEndpointInjection(this.getCamelContext(), uri, name, injectionPointName, mandatory);
    }

    private Endpoint doGetEndpointInjection(Object bean, String propertyName, String injectionPointName) {
        if (ObjectHelper.isEmpty(propertyName)) {
            propertyName = injectionPointName;
        }
        try {
            Object value = IntrospectionSupport.getOrElseProperty(bean, propertyName, null);
            if (value == null) {
                value = IntrospectionSupport.getOrElseProperty(bean, propertyName + "Endpoint", null);
            }
            if (value == null && propertyName.startsWith("on")) {
                propertyName = propertyName.substring(2);
                return this.doGetEndpointInjection(bean, propertyName, injectionPointName);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof Endpoint) {
                return (Endpoint)value;
            }
            String uriOrRef = this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
            return this.getCamelContext().getEndpoint(uriOrRef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error getting property " + propertyName + " from bean " + bean + " due " + e.getMessage(), e);
        }
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointRef, String endpointProperty, String injectionPointName, Object bean, String beanName) {
        return this.getInjectionValue(type, endpointUri, endpointRef, endpointProperty, injectionPointName, bean, beanName, true);
    }

    public Object getInjectionValue(Class<?> type, String endpointUri, String endpointRef, String endpointProperty, String injectionPointName, Object bean, String beanName, boolean binding) {
        if (type.isAssignableFrom(ProducerTemplate.class)) {
            return this.createInjectionProducerTemplate(endpointUri, endpointRef, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(FluentProducerTemplate.class)) {
            return this.createInjectionFluentProducerTemplate(endpointUri, endpointRef, endpointProperty, injectionPointName, bean);
        }
        if (type.isAssignableFrom(ConsumerTemplate.class)) {
            return this.createInjectionConsumerTemplate(endpointUri, endpointRef, endpointProperty, injectionPointName);
        }
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointRef, endpointProperty, injectionPointName, true);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint, bean, beanName);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint, bean, beanName);
            }
            if (type.isInterface()) {
                try {
                    return ProxyHelper.createProxy(endpoint, binding, type);
                }
                catch (Exception e) {
                    throw this.createProxyInstantiationRuntimeException(type, endpoint, e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject/@Produce for: " + endpoint);
        }
        return null;
    }

    public Object getInjectionPropertyValue(Class<?> type, String propertyName, String propertyDefaultValue, String injectionPointName, Object bean, String beanName) {
        try {
            CamelContextHelper.lookupPropertiesComponent(this.getCamelContext(), true);
            String prefix = this.getCamelContext().getPropertyPrefixToken();
            String suffix = this.getCamelContext().getPropertySuffixToken();
            String key = !propertyName.contains(prefix) ? prefix + propertyName + suffix : propertyName;
            String value = this.getCamelContext().resolvePropertyPlaceholders(key);
            if (value != null) {
                return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, value);
            }
            return null;
        }
        catch (Exception e) {
            if (ObjectHelper.isNotEmpty(propertyDefaultValue)) {
                try {
                    return this.getCamelContext().getTypeConverter().mandatoryConvertTo(type, propertyDefaultValue);
                }
                catch (Exception e2) {
                    throw ObjectHelper.wrapRuntimeCamelException(e2);
                }
            }
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public Object getInjectionBeanValue(Class<?> type, String name) {
        if (ObjectHelper.isEmpty(name)) {
            Set<?> found = this.getCamelContext().getRegistry().findByType(type);
            if (found == null || found.isEmpty()) {
                throw new NoSuchBeanException(name, type.getName());
            }
            if (found.size() > 1) {
                throw new NoSuchBeanException("Found " + found.size() + " beans of type: " + type + ". Only one bean expected.");
            }
            return found.iterator().next();
        }
        return CamelContextHelper.mandatoryLookup(this.getCamelContext(), name, type);
    }

    protected ProducerTemplate createInjectionProducerTemplate(String endpointUri, String endpointRef, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointRef, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultProducerTemplate answer = new DefaultProducerTemplate(context, endpoint);
        try {
            this.startService(answer, context, bean, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected FluentProducerTemplate createInjectionFluentProducerTemplate(String endpointUri, String endpointRef, String endpointProperty, String injectionPointName, Object bean) {
        Endpoint endpoint = this.getEndpointInjection(bean, endpointUri, endpointRef, endpointProperty, injectionPointName, false);
        CamelContext context = endpoint != null ? endpoint.getCamelContext() : this.getCamelContext();
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(context);
        answer.setDefaultEndpoint(endpoint);
        try {
            this.startService(answer, context, bean, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected ConsumerTemplate createInjectionConsumerTemplate(String endpointUri, String endpointRef, String endpointProperty, String injectionPointName) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContext());
        try {
            this.startService(answer, null, null, null);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint, Object bean, String beanName) {
        try {
            PollingConsumer consumer = endpoint.createPollingConsumer();
            this.startService(consumer, endpoint.getCamelContext(), bean, beanName);
            return consumer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint, Object bean, String beanName) {
        try {
            Producer producer = DeferServiceFactory.createProducer(endpoint);
            return new UnitOfWorkProducer(producer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    protected RuntimeException createProxyInstantiationRuntimeException(Class<?> type, Endpoint endpoint, Exception e) {
        return new ProxyInstantiationException(type, endpoint, e);
    }

    protected boolean isSingleton(Object bean, String beanName) {
        if (bean instanceof IsSingleton) {
            IsSingleton singleton = (IsSingleton)bean;
            return singleton.isSingleton();
        }
        return true;
    }
}

