/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import org.apache.camel.component.dataset.ListDataSet;

public class FileDataSet
extends ListDataSet {
    private File sourceFile;
    private String delimiter = "\\z";
    private List<Object> defaultBodies;

    public FileDataSet(String sourceFileName) throws IOException {
        this(new File(sourceFileName));
    }

    public FileDataSet(File sourceFile) throws IOException {
        this(sourceFile, "\\z");
    }

    public FileDataSet(String sourceFileName, String delimiter) throws IOException {
        this(new File(sourceFileName), delimiter);
    }

    public FileDataSet(File sourceFile, String delimiter) throws IOException {
        this.setSourceFile(sourceFile, delimiter);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) throws IOException {
        this.sourceFile = sourceFile;
        this.readSourceFile();
    }

    public void setSourceFile(File sourceFile, String delimiter) throws IOException {
        this.sourceFile = sourceFile;
        this.delimiter = delimiter;
        this.readSourceFile();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private void readSourceFile() throws IOException {
        LinkedList<Object> bodies = new LinkedList<Object>();
        try (BufferedReader br = new BufferedReader(new FileReader(this.sourceFile));){
            Scanner scanner = new Scanner(br);
            scanner.useDelimiter(this.delimiter);
            while (scanner.hasNext()) {
                String nextPayload = scanner.next();
                if (nextPayload == null || nextPayload.length() <= 0) continue;
                bodies.add(nextPayload);
            }
            this.setDefaultBodies(bodies);
        }
    }
}

