/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileBinding;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class FileConsumer
extends GenericFileConsumer<File> {
    private String endpointPath;
    private Set<String> extendedAttributes;

    public FileConsumer(FileEndpoint endpoint, Processor processor, GenericFileOperations<File> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
        if (endpoint.getExtendedAttributes() != null) {
            this.extendedAttributes = new HashSet<String>();
            for (String attribute : endpoint.getExtendedAttributes().split(",")) {
                this.extendedAttributes.add(attribute);
            }
        }
    }

    @Override
    protected boolean pollDirectory(String fileName, List<GenericFile<File>> fileList, int depth) {
        this.log.trace("pollDirectory from fileName: {}", (Object)fileName);
        ++depth;
        File directory = new File(fileName);
        if (!directory.exists() || !directory.isDirectory()) {
            this.log.debug("Cannot poll as directory does not exists or its not a directory: {}", (Object)directory);
            if (this.getEndpoint().isDirectoryMustExist()) {
                throw new GenericFileOperationFailedException("Directory does not exist: " + directory);
            }
            return true;
        }
        this.log.trace("Polling directory: {}", (Object)directory.getPath());
        File[] dirFiles = directory.listFiles();
        if (dirFiles == null || dirFiles.length == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No files found in directory: {}", (Object)directory.getPath());
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Found {} in directory: {}", (Object)dirFiles.length, (Object)directory.getPath());
        }
        List<File> files = Arrays.asList(dirFiles);
        if (this.getEndpoint().isPreSort()) {
            Collections.sort(files, (a, b) -> a.getAbsoluteFile().compareTo(a.getAbsoluteFile()));
        }
        for (File file : dirFiles) {
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Found file: {} [isAbsolute: {}, isDirectory: {}, isFile: {}, isHidden: {}]", file, file.isAbsolute(), file.isDirectory(), file.isFile(), file.isHidden());
            }
            GenericFile<File> gf = FileConsumer.asGenericFile(this.endpointPath, file, this.getEndpoint().getCharset(), this.getEndpoint().isProbeContentType());
            if (file.isDirectory()) {
                String subDirectory;
                boolean canPollMore;
                if (!this.endpoint.isRecursive() || depth >= this.endpoint.getMaxDepth() || !this.isValidFile(gf, true, files) || (canPollMore = this.pollDirectory(subDirectory = fileName + File.separator + file.getName(), fileList, depth))) continue;
                return false;
            }
            if (depth < this.endpoint.minDepth || !this.isValidFile(gf, false, files)) continue;
            this.log.trace("Adding valid file: {}", (Object)file);
            if (this.extendedAttributes != null) {
                Path path = file.toPath();
                HashMap<String, Object> allAttributes = new HashMap<String, Object>();
                for (String attribute : this.extendedAttributes) {
                    try {
                        String prefix = null;
                        if (attribute.endsWith(":*")) {
                            prefix = attribute.substring(0, attribute.length() - 1);
                        } else if (attribute.equals("*")) {
                            prefix = "basic:";
                        }
                        if (ObjectHelper.isNotEmpty(prefix)) {
                            Map<String, Object> attributes = Files.readAttributes(path, attribute, new LinkOption[0]);
                            if (attributes == null) continue;
                            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                                allAttributes.put(prefix + entry.getKey(), entry.getValue());
                            }
                            continue;
                        }
                        if (!attribute.contains(":")) {
                            allAttributes.put("basic:" + attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                            continue;
                        }
                        allAttributes.put(attribute, Files.getAttribute(path, attribute, new LinkOption[0]));
                    }
                    catch (IOException e) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Unable to read attribute {} on file {}", attribute, file, e);
                    }
                }
                gf.setExtendedAttributes(allAttributes);
            }
            fileList.add(gf);
        }
        return true;
    }

    @Override
    protected boolean isMatched(GenericFile<File> file, String doneFileName, List<File> files) {
        String onlyName = FileUtil.stripPath(doneFileName);
        for (File f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        this.log.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    @Deprecated
    public static GenericFile<File> asGenericFile(String endpointPath, File file, String charset) {
        return FileConsumer.asGenericFile(endpointPath, file, charset, false);
    }

    public static GenericFile<File> asGenericFile(String endpointPath, File file, String charset, boolean probeContentType) {
        GenericFile<File> answer = new GenericFile<File>(probeContentType);
        answer.setBinding(new FileBinding());
        answer.setCharset(charset);
        answer.setEndpointPath(endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.length());
        answer.setDirectory(file.isDirectory());
        answer.setAbsolute(FileUtil.isAbsolute(file));
        answer.setAbsoluteFilePath(file.getAbsolutePath());
        answer.setLastModified(file.lastModified());
        String endpointNormalized = FileUtil.normalizePath(endpointPath);
        File path = file.getPath().startsWith(endpointNormalized + File.separator) ? new File(ObjectHelper.after(file.getPath(), endpointNormalized + File.separator)) : new File(file.getPath());
        if (path.getParent() != null) {
            answer.setRelativeFilePath(path.getParent() + File.separator + file.getName());
        } else {
            answer.setRelativeFilePath(path.getName());
        }
        answer.setFileName(answer.getRelativeFilePath());
        answer.setBody(file);
        return answer;
    }

    @Override
    protected void updateFileHeaders(GenericFile<File> file, Message message) {
        long length = file.getFile().length();
        long modified = file.getFile().lastModified();
        file.setFileLength(length);
        file.setLastModified(modified);
        if (length >= 0L) {
            message.setHeader("CamelFileLength", length);
        }
        if (modified >= 0L) {
            message.setHeader("CamelFileLastModified", modified);
        }
    }

    @Override
    public FileEndpoint getEndpoint() {
        return (FileEndpoint)super.getEndpoint();
    }
}

