/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaConsumerNotAvailableException;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;

public class SedaProducer
extends DefaultAsyncProducer {
    @Deprecated
    protected final BlockingQueue<Exchange> queue;
    private final SedaEndpoint endpoint;
    private final WaitForTaskToComplete waitForTaskToComplete;
    private final long timeout;
    private final boolean blockWhenFull;

    @Deprecated
    public SedaProducer(SedaEndpoint endpoint, BlockingQueue<Exchange> queue2, WaitForTaskToComplete waitForTaskToComplete, long timeout) {
        this(endpoint, waitForTaskToComplete, timeout, false);
    }

    @Deprecated
    public SedaProducer(SedaEndpoint endpoint, BlockingQueue<Exchange> queue2, WaitForTaskToComplete waitForTaskToComplete, long timeout, boolean blockWhenFull) {
        this(endpoint, waitForTaskToComplete, timeout, blockWhenFull);
    }

    public SedaProducer(SedaEndpoint endpoint, WaitForTaskToComplete waitForTaskToComplete, long timeout, boolean blockWhenFull) {
        super(endpoint);
        this.queue = endpoint.getQueue();
        this.endpoint = endpoint;
        this.waitForTaskToComplete = waitForTaskToComplete;
        this.timeout = timeout;
        this.blockWhenFull = blockWhenFull;
    }

    @Override
    public boolean process(final Exchange exchange, AsyncCallback callback) {
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always || wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable(exchange)) {
            Exchange copy = this.prepareCopy(exchange, false);
            final CountDownLatch latch = new CountDownLatch(1);
            copy.addOnCompletion(new SynchronizationAdapter(){

                @Override
                public void onDone(Exchange response) {
                    if (latch.getCount() == 0L) {
                        if (SedaProducer.this.log.isTraceEnabled()) {
                            SedaProducer.this.log.trace("{}. Timeout occurred so response will be ignored: {}", (Object)this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                        }
                        return;
                    }
                    if (SedaProducer.this.log.isTraceEnabled()) {
                        SedaProducer.this.log.trace("{} with response: {}", (Object)this, (Object)(response.hasOut() ? response.getOut() : response.getIn()));
                    }
                    try {
                        ExchangeHelper.copyResults(exchange, response);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                @Override
                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "onDone at endpoint: " + SedaProducer.this.endpoint;
                }
            });
            this.log.trace("Adding Exchange to queue: {}", (Object)copy);
            try {
                this.addToQueue(copy, false);
            }
            catch (SedaConsumerNotAvailableException e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
            if (this.timeout > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Waiting for task to complete using timeout (ms): {} at [{}]", (Object)this.timeout, (Object)this.endpoint.getEndpointUri());
                }
                boolean done = false;
                try {
                    done = latch.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!done) {
                    exchange.setException(new ExchangeTimedOutException(exchange, this.timeout));
                    this.endpoint.getQueue().remove(copy);
                    latch.countDown();
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Waiting for task to complete (blocking) at [{}]", (Object)this.endpoint.getEndpointUri());
                }
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            try {
                this.addToQueue(exchange, true);
            }
            catch (SedaConsumerNotAvailableException e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        callback.done(true);
        return true;
    }

    protected Exchange prepareCopy(Exchange exchange, boolean handover) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, handover, true, synchronization -> !synchronization.getClass().getName().contains("RestBindingMarshalOnCompletion"));
        copy.setFromEndpoint(this.endpoint);
        return copy;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }

    protected void addToQueue(Exchange exchange, boolean copy) throws SedaConsumerNotAvailableException {
        boolean empty;
        BlockingQueue<Exchange> queue2 = null;
        QueueReference queueReference = this.endpoint.getQueueReference();
        if (queueReference != null) {
            queue2 = queueReference.getQueue();
        }
        if (queue2 == null) {
            throw new SedaConsumerNotAvailableException("No queue available on endpoint: " + this.endpoint, exchange);
        }
        boolean bl = empty = !queueReference.hasConsumers();
        if (empty) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new SedaConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
            if (this.endpoint.isDiscardIfNoConsumers()) {
                this.log.debug("Discard message as no active consumers on endpoint: {}", (Object)this.endpoint);
                return;
            }
        }
        Exchange target = exchange;
        if (copy) {
            target = this.prepareCopy(exchange, true);
        }
        this.log.trace("Adding Exchange to queue: {}", (Object)target);
        if (this.blockWhenFull) {
            try {
                queue2.put(target);
            }
            catch (InterruptedException e) {
                this.log.debug("Put interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else {
            queue2.add(target);
        }
    }
}

