/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;

public final class UnitOfWorkProducer
implements Producer {
    private final Producer producer;
    private final AsyncProcessor processor;

    public UnitOfWorkProducer(Producer producer) {
        this.producer = producer;
        CamelInternalProcessor internal = new CamelInternalProcessor(producer);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
        this.processor = internal;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this.processor, exchange);
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public String toString() {
        return "UnitOfWork(" + this.producer + ")";
    }
}

