/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.runtimecatalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.runtimecatalog.AbstractCamelCatalog;
import org.apache.camel.runtimecatalog.CamelContextJSonSchemaResolver;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;

public class DefaultRuntimeCamelCatalog
extends AbstractCamelCatalog
implements RuntimeCamelCatalog {
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean caching;

    public DefaultRuntimeCamelCatalog(CamelContext camelContext) {
        this(camelContext, false);
    }

    public DefaultRuntimeCamelCatalog(CamelContext camelContext, boolean caching) {
        this.caching = caching;
        this.setJSonSchemaResolver(new CamelContextJSonSchemaResolver(camelContext));
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.cache.clear();
    }

    @Override
    public String modelJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("model-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getModelJSonSchema(name);
            if (this.caching) {
                this.cache.put("model-" + name, answer);
            }
        }
        return answer;
    }

    @Override
    public String componentJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getComponentJSonSchema(name);
            if (this.caching) {
                this.cache.put("component-" + name, answer);
            }
        }
        return answer;
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getDataFormatJSonSchema(name);
            if (this.caching) {
                this.cache.put("dataformat-" + name, answer);
            }
        }
        return answer;
    }

    @Override
    public String languageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getLanguageJSonSchema(name);
            if (this.caching) {
                this.cache.put("language-" + name, answer);
            }
        }
        return answer;
    }
}

