/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.spring.spi.TransactionErrorHandler;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerBuilder
extends DefaultErrorHandlerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionErrorHandlerBuilder.class);
    private static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private TransactionTemplate transactionTemplate;
    private LoggingLevel rollbackLoggingLevel = LoggingLevel.WARN;

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public boolean supportTransacted() {
        return true;
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        if (this.transactionTemplate == null) {
            TransactedPolicy policy;
            LOG.debug("No TransactionTemplate configured on TransactionErrorHandlerBuilder. Will try find it in the registry.");
            Map<String, TransactedPolicy> mapPolicy = routeContext.lookupByType(TransactedPolicy.class);
            if (mapPolicy != null && mapPolicy.size() == 1 && (policy = mapPolicy.values().iterator().next()) instanceof SpringTransactionPolicy) {
                this.transactionTemplate = ((SpringTransactionPolicy)policy).getTransactionTemplate();
            }
            if (this.transactionTemplate == null && (policy = routeContext.lookup(PROPAGATION_REQUIRED, TransactedPolicy.class)) instanceof SpringTransactionPolicy) {
                this.transactionTemplate = ((SpringTransactionPolicy)policy).getTransactionTemplate();
            }
            if (this.transactionTemplate == null) {
                Map<String, TransactionTemplate> mapTemplate = routeContext.lookupByType(TransactionTemplate.class);
                if (mapTemplate == null || mapTemplate.isEmpty()) {
                    LOG.trace("No TransactionTemplate found in registry.");
                } else if (mapTemplate.size() == 1) {
                    this.transactionTemplate = mapTemplate.values().iterator().next();
                } else {
                    LOG.debug("Found {} TransactionTemplate in registry. Cannot determine which one to use. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder", (Object)mapTemplate.size());
                }
            }
            if (this.transactionTemplate == null) {
                Map<String, PlatformTransactionManager> mapManager = routeContext.lookupByType(PlatformTransactionManager.class);
                if (mapManager == null || mapManager.isEmpty()) {
                    LOG.trace("No PlatformTransactionManager found in registry.");
                } else if (mapManager.size() == 1) {
                    this.transactionTemplate = new TransactionTemplate(mapManager.values().iterator().next());
                } else {
                    LOG.debug("Found {} PlatformTransactionManager in registry. Cannot determine which one to use for TransactionTemplate. Please configure a TransactionTemplate on the TransactionErrorHandlerBuilder", (Object)mapManager.size());
                }
            }
            if (this.transactionTemplate != null) {
                LOG.debug("Found TransactionTemplate in registry to use: " + this.transactionTemplate);
            }
        }
        ObjectHelper.notNull(this.transactionTemplate, "transactionTemplate", this);
        TransactionErrorHandler answer = new TransactionErrorHandler(routeContext.getCamelContext(), processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getExceptionPolicyStrategy(), this.transactionTemplate, this.getRetryWhilePolicy(routeContext.getCamelContext()), this.getExecutorService(routeContext.getCamelContext()), this.getRollbackLoggingLevel(), this.getOnExceptionOccurred());
        this.configure(routeContext, answer);
        return answer;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setSpringTransactionPolicy(SpringTransactionPolicy policy) {
        this.transactionTemplate = policy.getTransactionTemplate();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
    }

    public LoggingLevel getRollbackLoggingLevel() {
        return this.rollbackLoggingLevel;
    }

    public void setRollbackLoggingLevel(LoggingLevel rollbackLoggingLevel) {
        this.rollbackLoggingLevel = rollbackLoggingLevel;
    }

    public TransactionErrorHandlerBuilder rollbackLoggingLevel(LoggingLevel rollbackLoggingLevel) {
        this.setRollbackLoggingLevel(rollbackLoggingLevel);
        return this;
    }

    @Override
    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(TransactionErrorHandler.class), LoggingLevel.ERROR);
    }

    @Override
    public String toString() {
        return "TransactionErrorHandlerBuilder";
    }
}

