/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2c;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xbean.spring.context.impl.QNameReflectionHelper;
import org.apache.xbean.spring.context.v2c.XBeanQNameHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String QNAME_ELEMENT = "qname";
    private XBeanQNameHelper qnameHelper;

    public XBeanBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
        this.qnameHelper = new XBeanQNameHelper(readerContext);
    }

    public Object parsePropertySubElement(Element ele, BeanDefinition bd, String defaultTypeClassName) {
        if (!this.isDefaultNamespace(ele.getNamespaceURI())) {
            return this.internalParseNestedCustomElement(ele, bd);
        }
        if (ele.getTagName().equals(QNAME_ELEMENT)) {
            return this.parseQNameElement(ele);
        }
        return super.parsePropertySubElement(ele, bd, defaultTypeClassName);
    }

    public AbstractBeanDefinition parseBeanDefinitionElement(Element ele, String beanName, BeanDefinition containingBean) {
        AbstractBeanDefinition bd = super.parseBeanDefinitionElement(ele, beanName, containingBean);
        this.qnameHelper.coerceNamespaceAwarePropertyValues(bd, ele);
        return bd;
    }

    public boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength(namespaceUri) || "http://www.springframework.org/schema/beans".equals(namespaceUri) || "http://xbean.apache.org/schemas/spring/1.0".equals(namespaceUri) || "http://xbean.org/schemas/spring/1.0".equals(namespaceUri);
    }

    protected Object parseQNameElement(Element element) {
        return QNameReflectionHelper.createQName(element, this.getElementText(element));
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size2 = nodeList.getLength();
        for (int i = 0; i < size2; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    private Object internalParseNestedCustomElement(Element candidateEle, BeanDefinition containingBeanDefinition) {
        try {
            Method mth = this.getClass().getSuperclass().getDeclaredMethod("parseNestedCustomElement", Element.class, BeanDefinition.class);
            mth.setAccessible(true);
            return mth.invoke((Object)this, candidateEle, containingBeanDefinition);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw (IllegalStateException)new IllegalStateException("Unable to invoke parseNestedCustomElement method").initCause(e);
        }
    }
}

