/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UserDestinationMessageHandler
implements MessageHandler,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(UserDestinationMessageHandler.class);
    private final SubscribableChannel clientInboundChannel;
    private final SubscribableChannel brokerChannel;
    private final UserDestinationResolver destinationResolver;
    private final MessageSendingOperations<String> messagingTemplate;
    private BroadcastHandler broadcastHandler;
    private MessageHeaderInitializer headerInitializer;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();

    public UserDestinationMessageHandler(SubscribableChannel clientInboundChannel, SubscribableChannel brokerChannel, UserDestinationResolver resolver) {
        Assert.notNull(clientInboundChannel, "'clientInChannel' must not be null");
        Assert.notNull(brokerChannel, "'brokerChannel' must not be null");
        Assert.notNull(resolver, "resolver must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.brokerChannel = brokerChannel;
        this.messagingTemplate = new SimpMessagingTemplate(brokerChannel);
        this.destinationResolver = resolver;
    }

    public UserDestinationResolver getUserDestinationResolver() {
        return this.destinationResolver;
    }

    public void setBroadcastDestination(String destination) {
        this.broadcastHandler = StringUtils.hasText(destination) ? new BroadcastHandler(this.messagingTemplate, destination) : null;
    }

    public String getBroadcastDestination() {
        return this.broadcastHandler != null ? this.broadcastHandler.getBroadcastDestination() : null;
    }

    public MessageSendingOperations<String> getBrokerMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    @Override
    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe(this);
            this.brokerChannel.subscribe(this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe(this);
            this.brokerChannel.unsubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        if (this.broadcastHandler != null && (message = this.broadcastHandler.preHandle(message)) == null) {
            return;
        }
        UserDestinationResult result = this.destinationResolver.resolveDestination(message);
        if (result == null) {
            return;
        }
        if (result.getTargetDestinations().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("No active sessions for user destination: " + result.getSourceDestination());
            }
            if (this.broadcastHandler != null) {
                this.broadcastHandler.handleUnresolved(message);
            }
            return;
        }
        SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.wrap(message);
        this.initHeaders(accessor);
        accessor.setNativeHeader("simpOrigDestination", result.getSubscribeDestination());
        accessor.setLeaveMutable(true);
        message = MessageBuilder.createMessage(message.getPayload(), accessor.getMessageHeaders());
        if (logger.isTraceEnabled()) {
            logger.trace("Translated " + result.getSourceDestination() + " -> " + result.getTargetDestinations());
        }
        for (String target : result.getTargetDestinations()) {
            this.messagingTemplate.send(target, message);
        }
    }

    private void initHeaders(SimpMessageHeaderAccessor headerAccessor) {
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
    }

    public String toString() {
        return "UserDestinationMessageHandler[" + this.destinationResolver + "]";
    }

    private static class BroadcastHandler {
        private static final List<String> NO_COPY_LIST = Arrays.asList("subscription", "message-id");
        private final MessageSendingOperations<String> messagingTemplate;
        private final String broadcastDestination;

        public BroadcastHandler(MessageSendingOperations<String> template, String destination) {
            this.messagingTemplate = template;
            this.broadcastDestination = destination;
        }

        public String getBroadcastDestination() {
            return this.broadcastDestination;
        }

        public Message<?> preHandle(Message<?> message) throws MessagingException {
            String destination = SimpMessageHeaderAccessor.getDestination(message.getHeaders());
            if (!this.getBroadcastDestination().equals(destination)) {
                return message;
            }
            SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.getAccessor(message, SimpMessageHeaderAccessor.class);
            if (accessor.getSessionId() == null) {
                return null;
            }
            destination = accessor.getFirstNativeHeader("simpOrigDestination");
            if (logger.isTraceEnabled()) {
                logger.trace("Checking unresolved user destination: " + destination);
            }
            SimpMessageHeaderAccessor newAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
            for (String name : accessor.toNativeHeaderMap().keySet()) {
                if (NO_COPY_LIST.contains(name)) continue;
                newAccessor.setNativeHeader(name, accessor.getFirstNativeHeader(name));
            }
            newAccessor.setDestination(destination);
            newAccessor.setHeader("simpIgnoreError", true);
            return MessageBuilder.createMessage(message.getPayload(), newAccessor.getMessageHeaders());
        }

        public void handleUnresolved(Message<?> message) {
            MessageHeaders headers = message.getHeaders();
            if (SimpMessageHeaderAccessor.getFirstNativeHeader("simpOrigDestination", headers) != null) {
                return;
            }
            SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.wrap(message);
            String destination = accessor.getDestination();
            accessor.setNativeHeader("simpOrigDestination", destination);
            accessor.setLeaveMutable(true);
            message = MessageBuilder.createMessage(message.getPayload(), accessor.getMessageHeaders());
            if (logger.isTraceEnabled()) {
                logger.trace("Translated " + destination + " -> " + this.getBroadcastDestination());
            }
            this.messagingTemplate.send(this.getBroadcastDestination(), message);
        }
    }
}

