/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.Service;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDiscoveryAgent
implements DiscoveryAgent {
    private static final Log LOG = LogFactory.getLog(HTTPDiscoveryAgent.class);
    private String registryURL = "http://localhost:8080/discovery-registry/default";
    private HttpClient httpClient = new HttpClient();
    private AtomicBoolean running = new AtomicBoolean();
    private final AtomicReference<DiscoveryListener> discoveryListener = new AtomicReference();
    private final HashSet<String> registeredServices = new HashSet();
    private final HashMap<String, SimpleDiscoveryEvent> discoveredServices = new HashMap();
    private Thread thread;
    private long updateInterval = 10000L;
    private String brokerName;
    private boolean startEmbeddRegistry = false;
    private Service jetty;
    private AtomicInteger startCounter = new AtomicInteger(0);
    private long initialReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private long backOffMultiplier = 2L;
    private boolean useExponentialBackOff = true;
    private int maxReconnectAttempts;
    private final Object sleepMutex = new Object();
    private long minConnectTime = 5000L;

    public String getGroup() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(String service) throws IOException {
        HashSet<String> hashSet = this.registeredServices;
        synchronized (hashSet) {
            this.registeredServices.add(service);
        }
        this.doRegister(service);
    }

    private synchronized void doRegister(String service) {
        String url = this.registryURL;
        try {
            PutMethod method = new PutMethod(url);
            method.setRequestHeader("service", service);
            int responseCode = this.httpClient.executeMethod((HttpMethod)method);
            LOG.debug("PUT to " + url + " got a " + responseCode);
        }
        catch (Exception e) {
            LOG.debug("PUT to " + url + " failed with: " + e);
        }
    }

    private synchronized void doUnRegister(String service) {
        String url = this.registryURL;
        try {
            DeleteMethod method = new DeleteMethod(url);
            method.setRequestHeader("service", service);
            int responseCode = this.httpClient.executeMethod((HttpMethod)method);
            LOG.debug("DELETE to " + url + " got a " + responseCode);
        }
        catch (Exception e) {
            LOG.debug("DELETE to " + url + " failed with: " + e);
        }
    }

    private synchronized Set<String> doLookup(long freshness) {
        String url = this.registryURL + "?freshness=" + freshness;
        try {
            GetMethod method = new GetMethod(url);
            int responseCode = this.httpClient.executeMethod((HttpMethod)method);
            LOG.debug("GET to " + url + " got a " + responseCode);
            if (responseCode == 200) {
                HashSet<String> rc = new HashSet<String>();
                Scanner scanner = new Scanner(method.getResponseBodyAsStream());
                while (scanner.hasNextLine()) {
                    String service = scanner.nextLine();
                    if (service.trim().length() == 0) continue;
                    rc.add(service);
                }
                return rc;
            }
            LOG.debug("GET to " + url + " failed with response code: " + responseCode);
            return null;
        }
        catch (Exception e) {
            LOG.debug("GET to " + url + " failed with: " + e);
            return null;
        }
    }

    @Override
    public void serviceFailed(DiscoveryEvent devent) throws IOException {
        final SimpleDiscoveryEvent event = (SimpleDiscoveryEvent)devent;
        if (event.failed.compareAndSet(false, true)) {
            this.discoveryListener.get().onServiceRemove(event);
            if (!event.removed.get()) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (event.connectTime + HTTPDiscoveryAgent.this.minConnectTime > System.currentTimeMillis()) {
                            LOG.debug("Failure occured soon after the discovery event was generated.  It will be clasified as a connection failure: " + event);
                            event.connectFailures++;
                            if (HTTPDiscoveryAgent.this.maxReconnectAttempts > 0 && event.connectFailures >= HTTPDiscoveryAgent.this.maxReconnectAttempts) {
                                LOG.debug("Reconnect attempts exceeded " + HTTPDiscoveryAgent.this.maxReconnectAttempts + " tries.  Reconnecting has been disabled.");
                                return;
                            }
                            Object object = HTTPDiscoveryAgent.this.sleepMutex;
                            synchronized (object) {
                                try {
                                    if (!HTTPDiscoveryAgent.this.running.get() || event.removed.get()) {
                                        return;
                                    }
                                    LOG.debug("Waiting " + event.reconnectDelay + " ms before attepting to reconnect.");
                                    HTTPDiscoveryAgent.this.sleepMutex.wait(event.reconnectDelay);
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            if (!HTTPDiscoveryAgent.this.useExponentialBackOff) {
                                event.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
                            } else {
                                event.reconnectDelay *= HTTPDiscoveryAgent.this.backOffMultiplier;
                                if (event.reconnectDelay > HTTPDiscoveryAgent.this.maxReconnectDelay) {
                                    event.reconnectDelay = HTTPDiscoveryAgent.this.maxReconnectDelay;
                                }
                            }
                        } else {
                            event.connectFailures = 0;
                            event.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
                        }
                        if (!HTTPDiscoveryAgent.this.running.get() || event.removed.get()) {
                            return;
                        }
                        event.connectTime = System.currentTimeMillis();
                        event.failed.set(false);
                        ((DiscoveryListener)HTTPDiscoveryAgent.this.discoveryListener.get()).onServiceAdd(event);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    @Override
    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener.set(discoveryListener);
    }

    public void setGroup(String group) {
    }

    @Override
    public void start() throws Exception {
        if (this.startCounter.addAndGet(1) == 1) {
            if (this.startEmbeddRegistry) {
                this.jetty = this.createEmbeddedJettyServer();
                HashMap<String, HTTPDiscoveryAgent> props = new HashMap<String, HTTPDiscoveryAgent>();
                props.put("agent", this);
                IntrospectionSupport.setProperties(this.jetty, props);
                this.jetty.start();
            }
            this.running.set(true);
            this.thread = new Thread("HTTPDiscovery Agent"){

                public void run() {
                    while (HTTPDiscoveryAgent.this.running.get()) {
                        try {
                            HTTPDiscoveryAgent.this.update();
                            Thread.sleep(HTTPDiscoveryAgent.this.updateInterval);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private Service createEmbeddedJettyServer() throws Exception {
        Class<?> clazz = HTTPDiscoveryAgent.class.getClassLoader().loadClass("org.apache.activemq.transport.discovery.http.EmbeddedJettyServer");
        return (Service)clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Set<String> activeServices;
        HashSet<String> hashSet = this.registeredServices;
        synchronized (hashSet) {
            for (String service : this.registeredServices) {
                this.doRegister(service);
            }
        }
        DiscoveryListener discoveryListener = this.discoveryListener.get();
        if (discoveryListener != null && (activeServices = this.doLookup(this.updateInterval * 3L)) != null) {
            HashMap<String, SimpleDiscoveryEvent> hashMap = this.discoveredServices;
            synchronized (hashMap) {
                SimpleDiscoveryEvent e;
                HashSet<String> removedServices = new HashSet<String>(this.discoveredServices.keySet());
                removedServices.removeAll(activeServices);
                HashSet<String> addedServices = new HashSet<String>(activeServices);
                addedServices.removeAll(this.discoveredServices.keySet());
                addedServices.removeAll(removedServices);
                for (String service : addedServices) {
                    e = new SimpleDiscoveryEvent(service);
                    this.discoveredServices.put(service, e);
                    discoveryListener.onServiceAdd(e);
                }
                for (String service : removedServices) {
                    e = this.discoveredServices.remove(service);
                    if (e != null) {
                        e.removed.set(true);
                    }
                    discoveryListener.onServiceRemove(e);
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.startCounter.decrementAndGet() == 0) {
            this.running.set(false);
            if (this.thread != null) {
                this.thread.join(this.updateInterval * 3L);
                this.thread = null;
            }
            if (this.jetty != null) {
                this.jetty.stop();
                this.jetty = null;
            }
        }
    }

    public String getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(String discoveryRegistryURL) {
        this.registryURL = discoveryRegistryURL;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public boolean isStartEmbeddRegistry() {
        return this.startEmbeddRegistry;
    }

    public void setStartEmbeddRegistry(boolean startEmbeddRegistry) {
        this.startEmbeddRegistry = startEmbeddRegistry;
    }

    class SimpleDiscoveryEvent
    extends DiscoveryEvent {
        private int connectFailures;
        private long reconnectDelay;
        private long connectTime;
        private AtomicBoolean failed;
        private AtomicBoolean removed;

        public SimpleDiscoveryEvent(String service) {
            super(service);
            this.reconnectDelay = HTTPDiscoveryAgent.this.initialReconnectDelay;
            this.connectTime = System.currentTimeMillis();
            this.failed = new AtomicBoolean(false);
            this.removed = new AtomicBoolean(false);
        }
    }
}

