/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuestLoginModule
implements LoginModule {
    private static final String GUEST_USER = "org.apache.activemq.jaas.guest.user";
    private static final String GUEST_GROUP = "org.apache.activemq.jaas.guest.group";
    private static final Log LOG = LogFactory.getLog(GuestLoginModule.class);
    private String userName = "guest";
    private String groupName = "guests";
    private Subject subject;
    private boolean debug;
    private Set<Principal> principals = new HashSet<Principal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (options.get(GUEST_USER) != null) {
            this.userName = (String)options.get(GUEST_USER);
        }
        if (options.get(GUEST_GROUP) != null) {
            this.groupName = (String)options.get(GUEST_GROUP);
        }
        this.principals.add(new UserPrincipal(this.userName));
        this.principals.add(new GroupPrincipal(this.groupName));
        if (this.debug) {
            LOG.debug("Initialized debug=" + this.debug + " guestUser=" + this.userName + " guestGroup=" + this.groupName);
        }
    }

    public boolean login() throws LoginException {
        if (this.debug) {
            LOG.debug("login " + this.userName);
        }
        return true;
    }

    public boolean commit() throws LoginException {
        this.subject.getPrincipals().addAll(this.principals);
        if (this.debug) {
            LOG.debug("commit");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            LOG.debug("abort");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        if (this.debug) {
            LOG.debug("logout");
        }
        return true;
    }
}

