/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.DAG;
import com.datatorrent.api.StreamingApplication;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;

public abstract class LocalMode {
    public abstract DAG getDAG();

    public abstract DAG cloneDAG() throws Exception;

    public abstract DAG prepareDAG(StreamingApplication var1, Configuration var2) throws Exception;

    public abstract Controller getController();

    public static LocalMode newInstance() {
        ServiceLoader<LocalMode> loader = ServiceLoader.load(LocalMode.class);
        Iterator<LocalMode> impl = loader.iterator();
        if (!impl.hasNext()) {
            throw new RuntimeException("No implementation for " + LocalMode.class);
        }
        return impl.next();
    }

    public static void runApp(StreamingApplication app, int runMillis) {
        LocalMode.runApp(app, null, runMillis);
    }

    public static void runApp(StreamingApplication app, Configuration configuration, int runMillis) {
        LocalMode lma = LocalMode.newInstance();
        app.populateDAG(lma.getDAG(), configuration == null ? new Configuration(false) : configuration);
        Controller lc = lma.getController();
        lc.run(runMillis);
    }

    public static interface Controller {
        public void run();

        public void run(long var1);

        public void runAsync();

        public void shutdown();

        public void setHeartbeatMonitoringEnabled(boolean var1);
    }
}

